/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import com.bugsnag.Client;
import com.bugsnag.Error;
import com.bugsnag.MetaData;
import com.bugsnag.Notification;
import com.bugsnag.android.ActivityStack;
import com.bugsnag.android.Diagnostics;
import com.bugsnag.android.Logger;
import com.bugsnag.http.BadResponseException;
import com.bugsnag.http.NetworkException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.UUID;
import org.json.JSONObject;

public class Bugsnag {
    private static Context applicationContext;
    private static String cachePath;
    private static Logger logger;
    private static Client client;
    private static String metricsEndpoint;
    static long startTime;

    public static void register(Context context, String string) {
        Bugsnag.register(context, string, false);
    }

    public static void register(Context object, String string, boolean bl) {
        String string2;
        logger = new Logger();
        client = new Client(string);
        client.setLogger((com.bugsnag.Logger)logger);
        applicationContext = object.getApplicationContext();
        cachePath = Bugsnag.prepareCachePath();
        object = applicationContext.getSharedPreferences("Bugsnag", 0);
        string = object.getString("userId", null);
        if (string == null) {
            string2 = string = UUID.randomUUID().toString();
            new AsyncTask<Void, Void, Void>((SharedPreferences)object, string2){
                private /* synthetic */ SharedPreferences val$settings;
                private /* synthetic */ String val$finalUuid;
                {
                    this.val$settings = sharedPreferences;
                    this.val$finalUuid = string;
                }
            }.execute((Object[])new Void[0]);
        }
        object = string;
        string = applicationContext.getPackageName();
        string2 = Bugsnag.getPackageVersion(string);
        client.setNotifierName("Android Bugsnag Notifier");
        client.setNotifierVersion("2.0.0");
        client.setUserId((String)object);
        client.setOsVersion(Build.VERSION.RELEASE);
        client.setAppVersion(string2);
        client.setProjectPackages(new String[]{string});
        client.addToTab("Device", "Android Version", (Object)Build.VERSION.RELEASE);
        client.addToTab("Device", "Device Type", (Object)Build.MODEL);
        client.addToTab("Application", "Package Name", (Object)string);
        client.addToTab("Application", "Package Version", (Object)string2);
        if (bl) {
            new AsyncTask<Void, Void, Void>((String)object){
                private /* synthetic */ String val$userId;
                {
                    this.val$userId = string;
                }

                private Void doInBackground$10299ca() {
                    Object object;
                    try {
                        object = client.createMetrics(object.val$userId);
                        object.deliver();
                    }
                    catch (NetworkException networkException) {
                        logger.info("Could not send metrics to Bugsnag");
                    }
                    catch (BadResponseException badResponseException) {
                        logger.warn(badResponseException.getMessage());
                    }
                    catch (Exception exception) {
                        object = exception;
                        exception.printStackTrace();
                    }
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }
        if (cachePath != null) {
            new AsyncTask<Void, Void, Void>(){

                private static Void doInBackground$10299ca() {
                    logger.debug("Flushing unsent errors (if any)");
                    Notification notification = client.createNotification();
                    LinkedList<File> linkedList = new LinkedList<File>();
                    File[] fileArray = new File(cachePath);
                    if (fileArray.exists() && fileArray.isDirectory()) {
                        for (File file : fileArray.listFiles()) {
                            if (!file.exists() || !file.isFile()) continue;
                            linkedList.add(file);
                            try {
                                Object object = file;
                                object = new RandomAccessFile((File)object, "r");
                                byte[] byArray = new byte[(int)((RandomAccessFile)object).length()];
                                ((RandomAccessFile)object).readFully(byArray);
                                ((RandomAccessFile)object).close();
                                object = new String(byArray);
                                notification.addError((String)object);
                                logger.debug(String.format("Added unsent error (%s) to notification", file.getName()));
                            }
                            catch (IOException iOException) {
                                logger.warn("Problem reading unsent error from disk", iOException);
                            }
                        }
                    }
                    try {
                        notification.deliver();
                        for (File file : linkedList) {
                            logger.debug("Deleting unsent error file " + file.getName());
                            file.delete();
                        }
                    }
                    catch (IOException iOException) {
                        logger.info("Could not flush error(s) to Bugsnag, will try again later");
                    }
                    catch (BadResponseException badResponseException) {
                        logger.warn(badResponseException.getMessage());
                    }
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }
        logger.info("Bugsnag is loaded and ready to handle exceptions");
    }

    public static void notify(Throwable throwable) {
        Bugsnag.notify(throwable, null);
    }

    public static void notify(Throwable throwable, MetaData object) {
        if (client == null) {
            Log.e((String)"Bugsnag", (String)"You must call register with an apiKey before we can notify of exceptions!");
            return;
        }
        Diagnostics diagnostics = new Diagnostics(applicationContext);
        object = diagnostics.merge((JSONObject)object);
        throwable = client.createError(throwable, object);
        object = ActivityStack.getTopActivityName();
        if (object != null) {
            throwable.setContext((String)object);
        }
        new AsyncTask<Void, Void, Void>((Error)throwable){
            private /* synthetic */ Error val$error;
            {
                this.val$error = error;
            }

            private Void doInBackground$10299ca() {
                try {
                    Notification notification = client.createNotification(this.val$error);
                    notification.deliver();
                }
                catch (NetworkException networkException) {
                    logger.info("Could not send error(s) to Bugsnag, saving to disk to send later");
                    Bugsnag.access$200(this.val$error);
                }
                catch (BadResponseException badResponseException) {
                    logger.warn(badResponseException.getMessage());
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    public static void setContext(String string) {
        client.setContext(string);
    }

    public static void setContext(Activity object) {
        object = ActivityStack.getContextName((Context)object);
        client.setContext((String)object);
    }

    public static void setUserId(String string) {
        client.setUserId(string);
    }

    public static void setReleaseStage(String string) {
        client.setReleaseStage(string);
    }

    public static void setNotifyReleaseStages(String ... stringArray) {
        client.setNotifyReleaseStages(stringArray);
    }

    public static void setAutoNotify(boolean bl) {
        client.setAutoNotify(bl);
    }

    public static void setUseSSL(boolean bl) {
        client.setUseSSL(bl);
    }

    public static void setEndpoint(String string) {
        client.setEndpoint(string);
    }

    public static void setMetricsEndpoint(String string) {
        metricsEndpoint = string;
    }

    public static String getMetricsEndpoint() {
        return (client.getUseSSL() ? "https://" : "http://") + metricsEndpoint;
    }

    public static void addToTab(String string, String string2, Object object) {
        client.addToTab(string, string2, object);
    }

    private static String getPackageVersion(String string) {
        String string2 = null;
        try {
            string = applicationContext.getPackageManager().getPackageInfo(string, 0);
            string2 = ((PackageInfo)string).versionName;
        }
        catch (Exception exception) {
            logger.warn("Could not get package version", exception);
        }
        return string2;
    }

    private static String prepareCachePath() {
        String string = null;
        try {
            string = applicationContext.getCacheDir().getAbsolutePath() + "/bugsnag-errors/";
            File file = new File(string);
            file.mkdirs();
            if (!file.exists()) {
                logger.warn("Could not prepare cache directory");
                string = null;
            }
        }
        catch (Exception exception) {
            logger.warn("Could not prepare cache directory", exception);
            string = null;
        }
        return string;
    }

    static /* synthetic */ void access$200(Error object) {
        block5: {
            if (cachePath == null || (object = object.toString()).isEmpty()) break block5;
            String string = String.format("%s%d.json", cachePath, System.currentTimeMillis());
            try {
                String string2 = string;
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(string2);
                    fileWriter.write((String)object);
                    fileWriter.flush();
                }
                catch (Throwable throwable) {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                    throw throwable;
                }
                fileWriter.close();
                logger.debug(String.format("Saved unsent error to disk (%s) ", string));
                return;
            }
            catch (IOException iOException) {
                logger.warn("Could not save error to disk", iOException);
            }
        }
    }

    static {
        metricsEndpoint = "notify.bugsnag.com/metrics";
        startTime = SystemClock.elapsedRealtime() / 1000L;
    }
}

