/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle.internal;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.ApkVariant;
import com.bugsnag.android.gradle.Abi;
import com.bugsnag.android.gradle.BugsnagGenerateUnitySoMappingTask;
import com.bugsnag.android.gradle.BugsnagPluginExtension;
import com.bugsnag.android.gradle.internal.NdkToolchainKt;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver.Version;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010J\u0006\u0010!\u001a\u00020\u0019R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/bugsnag/android/gradle/internal/NdkToolchain;", "", "()V", "baseDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBaseDir", "()Lorg/gradle/api/file/DirectoryProperty;", "bugsnagNdkVersion", "Lorg/gradle/api/provider/Property;", "", "getBugsnagNdkVersion", "()Lorg/gradle/api/provider/Property;", "logger", "Lorg/gradle/api/logging/Logger;", "overrides", "Lorg/gradle/api/provider/MapProperty;", "Lcom/bugsnag/android/gradle/Abi;", "getOverrides", "()Lorg/gradle/api/provider/MapProperty;", "useLegacyNdkSymbolUpload", "", "getUseLegacyNdkSymbolUpload", "variantName", "getVariantName", "detectMappingTool", "Lcom/bugsnag/android/gradle/internal/NdkToolchain$MappingTool;", "executableName", "cmdName", "locateObjcopy", "Ljava/io/File;", "abi", "objcopyForAbi", "objdumpForAbi", "preferredMappingTool", "Companion", "MappingTool", "bugsnag-android-gradle-plugin"})
public abstract class NdkToolchain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Version MIN_BUGSNAG_ANDROID_VERSION = new Version(5, 26, 0);
    @NotNull
    private static final Version MIN_NDK_OBJCOPY_VERSION = new Version(21, 0, 0);
    @NotNull
    private static final Version MIN_NDK_LLVM_VERSION = new Version(23, 0, 0);
    @Nullable
    private static final String osName = Os.isFamily((String)"mac") ? "darwin-x86_64" : (Os.isFamily((String)"unix") ? "linux-x86_64" : (Os.isFamily((String)"windows") ? (Intrinsics.areEqual((Object)"x86", (Object)System.getProperty("os.arch")) ? "windows" : "windows-x86_64") : null));

    public NdkToolchain() {
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this::class.java)");
        this.logger = logger;
    }

    @Internal
    @NotNull
    public abstract DirectoryProperty getBaseDir();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getUseLegacyNdkSymbolUpload();

    @Input
    @NotNull
    public abstract MapProperty<Abi, String> getOverrides();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getBugsnagNdkVersion();

    @Input
    @NotNull
    public abstract Property<String> getVariantName();

    @NotNull
    public final MappingTool preferredMappingTool() {
        Boolean forceNdkSymbolTool = (Boolean)this.getUseLegacyNdkSymbolUpload().getOrNull();
        if (forceNdkSymbolTool != null) {
            return Intrinsics.areEqual((Object)forceNdkSymbolTool, (Object)true) ? MappingTool.OBJDUMP : MappingTool.OBJCOPY;
        }
        return this.detectMappingTool();
    }

    /*
     * Unable to fully structure code
     */
    private final MappingTool detectMappingTool() {
        var2_1 = (String)this.getBugsnagNdkVersion().getOrNull();
        if (var2_1 == null) ** GOTO lbl-1000
        it = var2_1;
        $i$a$-let-NdkToolchain$detectMappingTool$legacyUploadRequired$1 = false;
        var3_4 = Version.parse((String)it);
        if (var3_4 != null) {
            it = var3_4;
            $i$a$-let-NdkToolchain$detectMappingTool$legacyUploadRequired$2 = false;
            v0 = it.compareTo(NdkToolchain.MIN_BUGSNAG_ANDROID_VERSION) < 0;
        } else lbl-1000:
        // 2 sources

        {
            v0 = legacyUploadRequired = null;
        }
        if (legacyUploadRequired == null) {
            this.logger.warn("Cannot detect Bugsnag SDK version for variant " + this.getVariantName().get() + ". To use the new upload functionality, version 5.26.0 of bugsnag-android is required. If this is not the case, please either upgrade the dependency or set bugsnag.useLegacyNdkSymbolUpload to use the legacy upload mechanism. See https://docs.bugsnag.com/build-integrations/gradle/#ndk-symbol-files for details.");
            legacyUploadRequired = false;
        }
        ndkVersion = (Version)NdkToolchainKt.access$getVersion(this).get();
        return legacyUploadRequired == false && ndkVersion.compareTo(NdkToolchain.MIN_NDK_OBJCOPY_VERSION) >= 0 ? MappingTool.OBJCOPY : MappingTool.OBJDUMP;
    }

    private final String executableName(String cmdName) {
        String string = osName;
        return (string != null ? StringsKt.startsWith$default((String)string, (String)"windows", (boolean)false, (int)2, null) : false) ? cmdName + ".exe" : cmdName;
    }

    @NotNull
    public final File objdumpForAbi(@NotNull Abi abi) {
        File file;
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        Map objdumpOverrides = (Map)this.getOverrides().get();
        String string = (String)objdumpOverrides.get((Object)abi);
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = new File((File)this.getBaseDir().getAsFile().get(), "toolchains/" + abi.getToolchainPrefix() + "-4.9/prebuilt/" + osName + "/bin/" + abi.getObjdumpPrefix() + "-" + this.executableName("objdump"));
        }
        return file;
    }

    @NotNull
    public final File objcopyForAbi(@NotNull Abi abi) {
        File file;
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        Map objcopyOverrides = (Map)this.getOverrides().get();
        String string = (String)objcopyOverrides.get((Object)abi);
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = this.locateObjcopy(abi);
        }
        return file;
    }

    private final File locateObjcopy(Abi abi) {
        Object object = NdkToolchainKt.access$isLLVMPreferred(this).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"isLLVMPreferred.get()");
        String relativeExecutablePath = (Boolean)object != false ? "toolchains/llvm/prebuilt/" + osName + "/bin/" + this.executableName("llvm-objcopy") : "toolchains/" + abi.getToolchainPrefix() + "-4.9/prebuilt/" + osName + "/bin/" + abi.getObjdumpPrefix() + "-" + this.executableName("objcopy");
        return new File((File)this.getBaseDir().getAsFile().get(), relativeExecutablePath);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/bugsnag/android/gradle/internal/NdkToolchain$MappingTool;", "", "(Ljava/lang/String;I)V", "OBJDUMP", "OBJCOPY", "bugsnag-android-gradle-plugin"})
    public static final class MappingTool
    extends Enum<MappingTool> {
        public static final /* enum */ MappingTool OBJDUMP = new MappingTool();
        public static final /* enum */ MappingTool OBJCOPY = new MappingTool();
        private static final /* synthetic */ MappingTool[] $VALUES;

        public static MappingTool[] values() {
            return (MappingTool[])$VALUES.clone();
        }

        public static MappingTool valueOf(String value) {
            return Enum.valueOf(MappingTool.class, value);
        }

        static {
            $VALUES = mappingToolArray = new MappingTool[]{MappingTool.OBJDUMP, MappingTool.OBJCOPY};
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/bugsnag/android/gradle/internal/NdkToolchain$Companion;", "", "()V", "MIN_BUGSNAG_ANDROID_VERSION", "Lorg/semver/Version;", "getMIN_BUGSNAG_ANDROID_VERSION$bugsnag_android_gradle_plugin", "()Lorg/semver/Version;", "MIN_NDK_LLVM_VERSION", "getMIN_NDK_LLVM_VERSION$bugsnag_android_gradle_plugin", "MIN_NDK_OBJCOPY_VERSION", "getMIN_NDK_OBJCOPY_VERSION$bugsnag_android_gradle_plugin", "osName", "", "configureNdkToolkit", "Lcom/bugsnag/android/gradle/internal/NdkToolchain;", "project", "Lorg/gradle/api/Project;", "bugsnag", "Lcom/bugsnag/android/gradle/BugsnagPluginExtension;", "variant", "Lcom/android/build/gradle/api/ApkVariant;", "getBugsnagAndroidNDKVersion", "bugsnag-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getMIN_BUGSNAG_ANDROID_VERSION$bugsnag_android_gradle_plugin() {
            return MIN_BUGSNAG_ANDROID_VERSION;
        }

        @NotNull
        public final Version getMIN_NDK_OBJCOPY_VERSION$bugsnag_android_gradle_plugin() {
            return MIN_NDK_OBJCOPY_VERSION;
        }

        @NotNull
        public final Version getMIN_NDK_LLVM_VERSION$bugsnag_android_gradle_plugin() {
            return MIN_NDK_LLVM_VERSION;
        }

        private final String getBugsnagAndroidNDKVersion(ApkVariant variant) {
            String string;
            try {
                ResolvedModuleVersion resolvedModuleVersion;
                Object v2;
                Iterable iterable;
                block3: {
                    Set set = variant.getCompileConfiguration().getResolvedConfiguration().getResolvedArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"variant.compileConfigura\u2026uration.resolvedArtifacts");
                    iterable = set;
                    for (Object t : iterable) {
                        ResolvedArtifact it = (ResolvedArtifact)t;
                        boolean bl = false;
                        boolean bl2 = Intrinsics.areEqual((Object)it.getModuleVersion().getId().getGroup(), (Object)"com.bugsnag") && Intrinsics.areEqual((Object)it.getModuleVersion().getId().getName(), (Object)"bugsnag-plugin-android-ndk");
                        if (!bl2) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                ResolvedArtifact resolvedArtifact = v2;
                String bugsnagAndroidCoreVersion = resolvedArtifact != null && (resolvedModuleVersion = resolvedArtifact.getModuleVersion()) != null && (iterable = resolvedModuleVersion.getId()) != null ? iterable.getVersion() : null;
            }
            catch (Exception e) {
                string = null;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NdkToolchain configureNdkToolkit(@NotNull Project project, @NotNull BugsnagPluginExtension bugsnag, @NotNull ApkVariant variant) {
            NdkToolchain ndkToolchain2;
            block3: {
                block2: {
                    void $this$newInstance$iv;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)bugsnag, (String)"bugsnag");
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    Boolean useLegacyNdkSymbolUpload = (Boolean)bugsnag.getUseLegacyNdkSymbolUpload().getOrNull();
                    Provider overrides = bugsnag.getObjdumpPaths().map(Companion::configureNdkToolkit$lambda-2);
                    ObjectFactory objectFactory = project.getObjects();
                    Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
                    ObjectFactory objectFactory2 = objectFactory;
                    Object[] parameters$iv = new Object[]{};
                    boolean $i$f$newInstance = false;
                    Object object = $this$newInstance$iv.newInstance(NdkToolchain.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(T::class.javaObjectType, *parameters)");
                    ndkToolchain2 = (NdkToolchain)object;
                    ndkToolchain2.getBaseDir().set(((BaseExtension)project.getExtensions().getByType(BaseExtension.class)).getNdkDirectory());
                    ndkToolchain2.getUseLegacyNdkSymbolUpload().set((Object)useLegacyNdkSymbolUpload);
                    ndkToolchain2.getOverrides().set(overrides);
                    if (useLegacyNdkSymbolUpload == null) break block2;
                    Object object2 = project.getExtensions().findByType(BaseExtension.class);
                    Intrinsics.checkNotNull((Object)object2);
                    if (BugsnagGenerateUnitySoMappingTask.Companion.isUnityLibraryUploadEnabled$bugsnag_android_gradle_plugin(bugsnag, (BaseExtension)object2)) break block3;
                }
                ndkToolchain2.getBugsnagNdkVersion().set(project.provider(() -> Companion.configureNdkToolkit$lambda-3(variant)));
            }
            ndkToolchain2.getVariantName().set((Object)variant.getName());
            return ndkToolchain2;
        }

        /*
         * WARNING - void declaration
         */
        private static final Map configureNdkToolkit$lambda-2(Map it) {
            void $this$mapKeysTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Map $this$mapKeys$iv = it;
            boolean $i$f$mapKeys = false;
            Map map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Abi abi;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                String abi2 = (String)entry.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)abi2, (String)"abi");
                Intrinsics.checkNotNull((Object)((Object)Abi.Companion.findByName(abi2)));
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = map2;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map3.put(abi, entry);
            }
            return destination$iv$iv;
        }

        private static final String configureNdkToolkit$lambda-3(ApkVariant $variant) {
            Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
            return Companion.getBugsnagAndroidNDKVersion($variant);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

