/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import com.bugsnag.android.JsonStream;
import com.bugsnag.android.internal.JsonCollectionParser;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FileSystemException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0001J\u0016\u0010\u000e\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u000e\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/bugsnag/android/internal/JsonHelper;", "", "()V", "deserialize", "", "", "inputStream", "Ljava/io/InputStream;", "data", "", "jsonToLong", "", "value", "(Ljava/lang/Object;)Ljava/lang/Long;", "serialize", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "", "file", "Ljava/io/File;", "stream", "Ljava/io/OutputStream;", "ulongToHex", "(Ljava/lang/Long;)Ljava/lang/String;", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nJsonHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonHelper.kt\ncom/bugsnag/android/internal/JsonHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class JsonHelper {
    @NotNull
    public static final JsonHelper INSTANCE = new JsonHelper();

    private JsonHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(@NotNull JsonStream.Streamable streamable) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            byte[] byArray2;
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new PrintWriter(baos);
            Throwable throwable2 = null;
            try {
                PrintWriter pw = (PrintWriter)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new JsonStream(pw);
                Throwable throwable3 = null;
                try {
                    JsonStream p0 = (JsonStream)closeable3;
                    boolean bl3 = false;
                    streamable.toStream(p0);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                byArray2 = baos.toByteArray();
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(@NotNull Object value) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            INSTANCE.serialize(value, baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(@NotNull Object value, @NotNull OutputStream stream) {
        Closeable closeable = stream;
        Object object = Charsets.UTF_8;
        Closeable closeable2 = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = closeable2 instanceof BufferedWriter ? (BufferedWriter)closeable2 : new BufferedWriter((Writer)closeable2, n);
        object = null;
        try {
            JsonStream jsonStream;
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            Closeable closeable3 = new JsonStream(writer);
            Throwable throwable = null;
            try {
                JsonStream jsonWriter = (JsonStream)closeable3;
                boolean bl2 = false;
                jsonStream = jsonWriter.value(value);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable);
            }
            closeable2 = jsonStream;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(@NotNull Object value, @NotNull File file) {
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new FileSystemException(file, null, "Could not create parent dirs of file");
        }
        try {
            Closeable closeable = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                FileOutputStream stream = (FileOutputStream)closeable;
                boolean bl = false;
                INSTANCE.serialize(value, stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ex) {
            throw new IOException("Could not serialize JSON document to " + file, ex);
        }
    }

    @NotNull
    public final Map<String, Object> deserialize(@NotNull byte[] data) {
        return this.deserialize(new ByteArrayInputStream(data));
    }

    @NotNull
    public final Map<String, Object> deserialize(@NotNull InputStream inputStream) {
        JsonCollectionParser parser = new JsonCollectionParser(inputStream);
        Object result = parser.parse();
        if (!(result instanceof Map)) {
            throw new IllegalArgumentException("Expected JSON object at root level");
        }
        Intrinsics.checkNotNull((Object)result, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        return (Map)result;
    }

    @Nullable
    public final String ulongToHex(@Nullable Long value) {
        String string;
        if (value == null) {
            string = null;
        } else if (value >= 0L) {
            String string2 = "0x%x";
            Object[] objectArray = new Object[]{value};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        } else {
            String string4 = "0x%x%02x";
            Object[] objectArray = new Object[]{value >>> 8, value & 0xFFL};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
            return string5;
        }
        return string;
    }

    @Nullable
    public final Long jsonToLong(@Nullable Object value) {
        Long l;
        Object object = value;
        if (object == null) {
            l = null;
        } else if (object instanceof Number) {
            l = ((Number)value).longValue();
        } else if (object instanceof String) {
            if (((CharSequence)value).length() == 0) {
                l = null;
            } else {
                Long l2;
                try {
                    l2 = Long.decode((String)value);
                }
                catch (NumberFormatException e) {
                    long l3;
                    if (StringsKt.startsWith$default((String)((String)value), (String)"0x", (boolean)false, (int)2, null)) {
                        if (((String)value).length() != 18) {
                            throw e;
                        }
                        int headLength = ((String)value).length() - 2;
                        String string = ((String)value).substring(0, headLength);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        long l4 = Long.decode(string) << 8;
                        String string2 = ((String)value).substring(headLength, ((String)value).length());
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        l3 = l4 | Long.parseLong(string2, CharsKt.checkRadix((int)16));
                    } else {
                        if (((String)value).length() < 19) {
                            throw e;
                        }
                        int headLength = ((String)value).length() - 3;
                        String string = ((String)value).substring(0, headLength);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        long l5 = Long.decode(string) * (long)1000;
                        String string3 = ((String)value).substring(headLength, ((String)value).length());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        l3 = l5 + Long.decode(string3);
                    }
                    l2 = l3;
                }
                l = l2;
            }
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to long");
        }
        return l;
    }
}

