/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.Intrinsics;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Severity;
import java.io.IOException;

final class SeverityReason
implements JsonStream.Streamable {
    static final String REASON_UNHANDLED_EXCEPTION = "unhandledException";
    static final String REASON_STRICT_MODE = "strictMode";
    static final String REASON_HANDLED_EXCEPTION = "handledException";
    static final String REASON_HANDLED_ERROR = "handledError";
    static final String REASON_USER_SPECIFIED = "userSpecifiedSeverity";
    static final String REASON_CALLBACK_SPECIFIED = "userCallbackSetSeverity";
    static final String REASON_PROMISE_REJECTION = "unhandledPromiseRejection";
    static final String REASON_SIGNAL = "signal";
    static final String REASON_LOG = "log";
    static final String REASON_ANR = "anrError";
    static final String REASON_HTTP_ERROR = "httpError";
    private final String severityReasonType;
    @Nullable
    private final String attributeKey;
    @Nullable
    private final String attributeValue;
    private final Severity defaultSeverity;
    private Severity currentSeverity;
    private boolean unhandled;
    final boolean originalUnhandled;

    static SeverityReason newInstance(String severityReasonType) {
        return SeverityReason.newInstance(severityReasonType, null, null);
    }

    static SeverityReason newInstance(String reason, @Nullable Severity severity, @Nullable String attrVal) {
        if (reason.equals(REASON_STRICT_MODE) && Intrinsics.isEmpty(attrVal)) {
            throw new IllegalArgumentException("No reason supplied for strictmode");
        }
        if (!(reason.equals(REASON_STRICT_MODE) || reason.equals(REASON_LOG) || Intrinsics.isEmpty(attrVal))) {
            throw new IllegalArgumentException("attributeValue should not be supplied");
        }
        switch (reason) {
            case "unhandledException": 
            case "unhandledPromiseRejection": 
            case "signal": 
            case "anrError": {
                return new SeverityReason(reason, Severity.ERROR, true, true, null, null);
            }
            case "strictMode": {
                return new SeverityReason(reason, Severity.WARNING, true, true, attrVal, "violationType");
            }
            case "handledError": 
            case "handledException": 
            case "httpError": {
                return new SeverityReason(reason, Severity.WARNING, false, false, null, null);
            }
            case "userSpecifiedSeverity": 
            case "userCallbackSetSeverity": {
                return new SeverityReason(reason, severity, false, false, null, null);
            }
            case "log": {
                return new SeverityReason(reason, severity, false, false, attrVal, "level");
            }
        }
        String msg = "Invalid argument for severityReason: '" + reason + '\'';
        throw new IllegalArgumentException(msg);
    }

    SeverityReason(String severityReasonType, Severity currentSeverity, boolean unhandled, boolean originalUnhandled, @Nullable String attributeValue, @Nullable String attributeKey) {
        this.severityReasonType = severityReasonType;
        this.unhandled = unhandled;
        this.originalUnhandled = originalUnhandled;
        this.defaultSeverity = currentSeverity;
        this.currentSeverity = currentSeverity;
        this.attributeValue = attributeValue;
        this.attributeKey = attributeKey;
    }

    String calculateSeverityReasonType() {
        return this.defaultSeverity == this.currentSeverity ? this.severityReasonType : REASON_CALLBACK_SPECIFIED;
    }

    Severity getCurrentSeverity() {
        return this.currentSeverity;
    }

    boolean getUnhandled() {
        return this.unhandled;
    }

    void setUnhandled(boolean unhandled) {
        this.unhandled = unhandled;
    }

    boolean getUnhandledOverridden() {
        return this.unhandled != this.originalUnhandled;
    }

    boolean isOriginalUnhandled() {
        return this.originalUnhandled;
    }

    @Nullable
    String getAttributeValue() {
        return this.attributeValue;
    }

    String getAttributeKey() {
        return this.attributeKey;
    }

    void setCurrentSeverity(Severity severity) {
        this.currentSeverity = severity;
    }

    String getSeverityReasonType() {
        return this.severityReasonType;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject().name("type").value(this.calculateSeverityReasonType()).name("unhandledOverridden").value(this.getUnhandledOverridden());
        if (this.attributeKey != null && this.attributeValue != null) {
            writer.name("attributes").beginObject().name(this.attributeKey).value(this.attributeValue).endObject();
        }
        writer.endObject();
    }
}

