/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.AbstractHttpEntity;
import com.bugsnag.android.JsonStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Request
extends AbstractHttpEntity
implements JsonStream.Streamable {
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    @Nullable
    private String httpMethod;
    @Nullable
    private String httpVersion;
    @Nullable
    private String url;

    public Request(@Nullable String httpVersion, @Nullable String httpMethod, @Nullable String url) {
        this.httpMethod = httpMethod;
        this.httpVersion = httpVersion;
        this.setUrl(url);
    }

    public Request(@Nullable String httpMethod, @Nullable String url) {
        this(null, httpMethod, url);
    }

    @Nullable
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(@Nullable String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Nullable
    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(@Nullable String httpVersion) {
        this.httpVersion = httpVersion;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        if (url != null) {
            int querySeparatorIndex = url.indexOf(63);
            if (querySeparatorIndex > 0) {
                try {
                    this.tryUrlWithQueryString(url);
                }
                catch (RuntimeException re) {
                    this.url = url.substring(0, querySeparatorIndex);
                }
            } else {
                this.url = url;
            }
        } else {
            this.url = "";
            this.params.clear();
        }
    }

    private void tryUrlWithQueryString(@NonNull String url) {
        Uri uri = Uri.parse((String)url);
        this.params.clear();
        for (String queryName : uri.getQueryParameterNames()) {
            this.params.put(queryName, uri.getQueryParameter(queryName));
        }
        this.url = uri.buildUpon().clearQuery().build().toString();
    }

    public void addQueryParameter(@NonNull String name, @Nullable String value) {
        if (name != null) {
            this.params.put(name, value);
        }
    }

    public void removeQueryParameter(@NonNull String name) {
        this.params.remove(name);
    }

    @NonNull
    public Set<String> getQueryParameterNames() {
        return Collections.unmodifiableSet(this.params.keySet());
    }

    @Nullable
    public String getQueryParameter(@NonNull String name) {
        return this.params.get(name);
    }

    @Override
    public void toStream(@NotNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("httpMethod").value(this.httpMethod);
        writer.name("httpVersion").value(this.httpVersion);
        writer.name("url").value(this.url);
        writer.name("body").value(this.getBody());
        long bodyLength = this.getBodyLength();
        if (bodyLength >= 0L) {
            writer.name("bodyLength").value(bodyLength);
        }
        writer.name("headers").value(this.headers, true);
        writer.name("params").value(this.params, true);
        writer.endObject();
    }
}

