/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.dag.Provider;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0002+,B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0019J\u0016\u0010\u001a\u001a\u00020\u00172\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0019J\u0006\u0010\u001c\u001a\u00020\u0017J\u0018\u0010\u001d\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001fJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"J\u0012\u0010#\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u0001H&J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010\u001f2\u0006\u0010)\u001a\u00020*R \u0010\b\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lcom/bugsnag/android/FileStore;", "", "storageDir", "Ljava/io/File;", "maxStoreCount", "", "logger", "Lcom/bugsnag/android/Logger;", "delegate", "Lcom/bugsnag/android/internal/dag/Provider;", "Lcom/bugsnag/android/FileStore$Delegate;", "(Ljava/io/File;ILcom/bugsnag/android/Logger;Lcom/bugsnag/android/internal/dag/Provider;)V", "getDelegate", "()Lcom/bugsnag/android/internal/dag/Provider;", "lock", "Ljava/util/concurrent/locks/Lock;", "getLogger", "()Lcom/bugsnag/android/Logger;", "queuedFiles", "", "getStorageDir", "()Ljava/io/File;", "cancelQueuedFiles", "", "files", "", "deleteStoredFiles", "storedFiles", "discardOldestFileIfNeeded", "enqueueContentForDelivery", "content", "", "filename", "findStoredFiles", "", "getFilename", "obj", "isEmpty", "", "isStorageDirValid", "write", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "Delegate", "FileWithTimestamp", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nFileStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStore.kt\ncom/bugsnag/android/FileStore\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,214:1\n11400#2,3:215\n*S KotlinDebug\n*F\n+ 1 FileStore.kt\ncom/bugsnag/android/FileStore\n*L\n120#1:215,3\n*E\n"})
public abstract class FileStore {
    @NotNull
    private final File storageDir;
    private final int maxStoreCount;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Provider<? extends Delegate> delegate;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Collection<File> queuedFiles;

    public FileStore(@NotNull File storageDir, int maxStoreCount, @NotNull Logger logger, @Nullable Provider<? extends Delegate> delegate) {
        this.storageDir = storageDir;
        this.maxStoreCount = maxStoreCount;
        this.logger = logger;
        this.delegate = delegate;
        this.lock = new ReentrantLock();
        this.queuedFiles = new ConcurrentSkipListSet();
    }

    @NotNull
    public final File getStorageDir() {
        return this.storageDir;
    }

    @NotNull
    protected Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final Provider<? extends Delegate> getDelegate() {
        return this.delegate;
    }

    private final boolean isStorageDirValid(File storageDir) {
        try {
            storageDir.mkdirs();
        }
        catch (Exception exception) {
            this.getLogger().e("Could not prepare file storage directory", exception);
            return false;
        }
        return true;
    }

    public final boolean isEmpty() {
        String[] stringArray;
        return this.queuedFiles.isEmpty() && ((stringArray = this.storageDir.list()) == null || stringArray.length == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void enqueueContentForDelivery(@Nullable String content, @NotNull String filename) {
        block14: {
            if (!this.isStorageDirValid(this.storageDir)) {
                return;
            }
            this.discardOldestFileIfNeeded();
            this.lock.lock();
            out = null;
            filePath = new File(this.storageDir, filename).getAbsolutePath();
            try {
                fos = new FileOutputStream(filePath);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                ((BufferedWriter)out).write(content);
                ** try [egrp 1[TRYBLOCK] [0 : 92->100)] { 
            }
            catch (Exception exc) {
                eventFile = new File(filePath);
                v0 = this.delegate;
                if (v0 != null && (v0 = v0.getOrNull()) != null) {
                    v0.onErrorIOFailure(exc, eventFile, "NDK Crash report copy");
                }
                IOUtils.deleteFile(eventFile, this.getLogger());
                break block14;
            }
            finally {
                try {
                    v1 = out;
                    if (v1 != null) {
                        v1.close();
                    }
                }
                catch (Exception exception) {
                    this.getLogger().w("Failed to close unsent payload writer: " + filename, exception);
                }
                this.lock.unlock();
            }
lbl-1000:
            // 1 sources

            {
                out.close();
            }
lbl16:
            // 1 sources

            catch (Exception exception) {
                this.getLogger().w("Failed to close unsent payload writer: " + filename, exception);
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String write(@NotNull JsonStream.Streamable streamable) {
        if (!this.isStorageDirValid(this.storageDir)) {
            return null;
        }
        if (this.maxStoreCount == 0) {
            return null;
        }
        this.discardOldestFileIfNeeded();
        String filename = new File(this.storageDir, this.getFilename(streamable)).getAbsolutePath();
        JsonStream stream = null;
        this.lock.lock();
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            Writer out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            stream = new JsonStream(out);
            stream.value(streamable);
            this.getLogger().i("Saved unsent payload to disk: '" + filename + '\'');
            String string = filename;
            return string;
        }
        catch (FileNotFoundException exc) {
            this.getLogger().w("Ignoring FileNotFoundException - unable to create file", exc);
        }
        catch (Exception exc) {
            File eventFile = new File(filename);
            Provider<? extends Delegate> provider2 = this.delegate;
            if (provider2 != null && (provider2 = provider2.getOrNull()) != null) {
                provider2.onErrorIOFailure(exc, eventFile, "Crash report serialization");
            }
            IOUtils.deleteFile(eventFile, this.getLogger());
        }
        finally {
            IOUtils.closeQuietly(stream);
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void discardOldestFileIfNeeded() {
        void $this$mapTo$iv;
        if (!this.isStorageDirValid(this.storageDir)) {
            return;
        }
        File[] fileArray = this.storageDir.listFiles();
        if (fileArray == null) {
            return;
        }
        File[] listFiles = fileArray;
        if (listFiles.length < this.maxStoreCount) {
            return;
        }
        File[] fileArray2 = listFiles;
        Collection destination$iv = new ArrayList(listFiles.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void file;
            void item$iv;
            void var9_13 = item$iv = $this$mapTo$iv[i];
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(new FileWithTimestamp((File)file, file.lastModified()));
        }
        ArrayList timestampedFiles = (ArrayList)destination$iv;
        CollectionsKt.sort((List)timestampedFiles);
        int numberToDiscard = listFiles.length - this.maxStoreCount + 1;
        int discardedCount = 0;
        for (FileWithTimestamp fileMeta : timestampedFiles) {
            File file = fileMeta.getFile();
            if (discardedCount == numberToDiscard) {
                return;
            }
            if (this.queuedFiles.contains(file)) continue;
            this.getLogger().w("Discarding oldest error as stored error limit reached: '" + file.getPath() + '\'');
            this.deleteStoredFiles(SetsKt.setOf((Object)file));
            ++discardedCount;
        }
    }

    @NotNull
    public abstract String getFilename(@Nullable Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> findStoredFiles() {
        void var1_1;
        this.lock.lock();
        try {
            File[] values;
            List files = new ArrayList();
            if (this.isStorageDirValid(this.storageDir) && (values = this.storageDir.listFiles()) != null) {
                for (File value : values) {
                    if (value.length() == 0L) {
                        if (value.delete()) continue;
                        value.deleteOnExit();
                        continue;
                    }
                    if (!value.isFile() || this.queuedFiles.contains(value)) continue;
                    files.add(value);
                }
            }
            this.queuedFiles.addAll(files);
        }
        finally {
            this.lock.unlock();
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelQueuedFiles(@Nullable Collection<? extends File> files) {
        this.lock.lock();
        try {
            if (files != null) {
                this.queuedFiles.removeAll(files);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteStoredFiles(@Nullable Collection<? extends File> storedFiles) {
        this.lock.lock();
        try {
            if (storedFiles != null) {
                this.queuedFiles.removeAll(storedFiles);
                for (File file : storedFiles) {
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH&\u00a8\u0006\u000b"}, d2={"Lcom/bugsnag/android/FileStore$Delegate;", "", "onErrorIOFailure", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorFile", "Ljava/io/File;", "context", "", "bugsnag-android-core_release"})
    public static interface Delegate {
        public void onErrorIOFailure(@Nullable Exception var1, @Nullable File var2, @Nullable String var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/bugsnag/android/FileStore$FileWithTimestamp;", "", "file", "Ljava/io/File;", "timestamp", "", "(Ljava/io/File;J)V", "getFile", "()Ljava/io/File;", "getTimestamp", "()J", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "bugsnag-android-core_release"})
    private static final class FileWithTimestamp
    implements Comparable<FileWithTimestamp> {
        @NotNull
        private final File file;
        private final long timestamp;

        public FileWithTimestamp(@NotNull File file, long timestamp) {
            this.file = file;
            this.timestamp = timestamp;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public int compareTo(@NotNull FileWithTimestamp other) {
            return Intrinsics.compare((long)this.timestamp, (long)other.timestamp);
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final FileWithTimestamp copy(@NotNull File file, long timestamp) {
            return new FileWithTimestamp(file, timestamp);
        }

        public static /* synthetic */ FileWithTimestamp copy$default(FileWithTimestamp fileWithTimestamp, File file, long l, int n, Object object) {
            if ((n & 1) != 0) {
                file = fileWithTimestamp.file;
            }
            if ((n & 2) != 0) {
                l = fileWithTimestamp.timestamp;
            }
            return fileWithTimestamp.copy(file, l);
        }

        @NotNull
        public String toString() {
            return "FileWithTimestamp(file=" + this.file + ", timestamp=" + this.timestamp + ')';
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileWithTimestamp)) {
                return false;
            }
            FileWithTimestamp fileWithTimestamp = (FileWithTimestamp)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)fileWithTimestamp.file)) {
                return false;
            }
            return this.timestamp == fileWithTimestamp.timestamp;
        }
    }
}

