/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.Deliverable;
import com.bugsnag.android.ErrorType;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventFilenameInfo;
import com.bugsnag.android.EventInternal;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MarshalledEventSource;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.Stacktrace;
import com.bugsnag.android.Thread;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.JsonHelper;
import com.bugsnag.android.internal.TrimMetrics;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B9\b\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u00020\u0006H\u0002J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0000\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\u0013H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u00020\u00002\b\b\u0002\u0010.\u001a\u00020/H\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00061"}, d2={"Lcom/bugsnag/android/EventPayload;", "Lcom/bugsnag/android/JsonStream$Streamable;", "Lcom/bugsnag/android/Deliverable;", "apiKey", "", "event", "Lcom/bugsnag/android/Event;", "eventFile", "Ljava/io/File;", "notifier", "Lcom/bugsnag/android/Notifier;", "config", "Lcom/bugsnag/android/internal/ImmutableConfig;", "(Ljava/lang/String;Lcom/bugsnag/android/Event;Ljava/io/File;Lcom/bugsnag/android/Notifier;Lcom/bugsnag/android/internal/ImmutableConfig;)V", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "cachedBytes", "", "<set-?>", "getEvent", "()Lcom/bugsnag/android/Event;", "setEvent$bugsnag_android_core_release", "(Lcom/bugsnag/android/Event;)V", "getEventFile$bugsnag_android_core_release", "()Ljava/io/File;", "logger", "Lcom/bugsnag/android/Logger;", "getLogger", "()Lcom/bugsnag/android/Logger;", "getNotifier$bugsnag_android_core_release", "()Lcom/bugsnag/android/Notifier;", "decodedEvent", "getErrorTypes", "", "Lcom/bugsnag/android/ErrorType;", "getErrorTypes$bugsnag_android_core_release", "rebuildPayloadCache", "rebuildPayloadCache$bugsnag_android_core_release", "toByteArray", "toStream", "", "writer", "Lcom/bugsnag/android/JsonStream;", "trimToSize", "maxSizeBytes", "", "Companion", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nEventPayload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventPayload.kt\ncom/bugsnag/android/EventPayload\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class EventPayload
implements JsonStream.Streamable,
Deliverable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String apiKey;
    @NotNull
    private final ImmutableConfig config;
    @Nullable
    private Event event;
    @Nullable
    private File eventFile;
    @Nullable
    private byte[] cachedBytes;
    @NotNull
    private final Notifier notifier;
    public static final int DEFAULT_MAX_PAYLOAD_SIZE = 999700;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public EventPayload(@Nullable String apiKey, @Nullable Event event, @Nullable File eventFile, @NotNull Notifier notifier, @NotNull ImmutableConfig config) {
        void $this$notifier_u24lambda_u240;
        Notifier notifier2;
        this.apiKey = apiKey;
        this.config = config;
        this.event = event;
        this.eventFile = eventFile;
        Notifier notifier3 = notifier2 = new Notifier(notifier.getName(), notifier.getVersion(), notifier.getUrl());
        EventPayload eventPayload = this;
        boolean bl = false;
        $this$notifier_u24lambda_u240.setDependencies(CollectionsKt.toMutableList((Collection)notifier.getDependencies()));
        eventPayload.notifier = notifier2;
    }

    public /* synthetic */ EventPayload(String string, Event event, File file, Notifier notifier, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            event = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        this(string, event, file, notifier, immutableConfig);
    }

    @Nullable
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@Nullable String string) {
        this.apiKey = string;
    }

    @Nullable
    public final Event getEvent() {
        return this.event;
    }

    public final void setEvent$bugsnag_android_core_release(@Nullable Event event) {
        this.event = event;
    }

    @Nullable
    public final File getEventFile$bugsnag_android_core_release() {
        return this.eventFile;
    }

    private final Logger getLogger() {
        return this.config.getLogger();
    }

    @NotNull
    public final Notifier getNotifier$bugsnag_android_core_release() {
        return this.notifier;
    }

    @NotNull
    public final Set<ErrorType> getErrorTypes$bugsnag_android_core_release() {
        Object object;
        block2: {
            block3: {
                Event event = this.event;
                object = event;
                if (object != null && (object = ((Event)object).getImpl()) != null && (object = ((EventInternal)object).getErrorTypesFromStackframes$bugsnag_android_core_release()) != null) break block2;
                object = this.eventFile;
                if (object == null) break block3;
                Set<ErrorType> it = object;
                boolean bl = false;
                Set<ErrorType> set = EventFilenameInfo.Companion.fromFile((File)((Object)it), this.config).getErrorTypes();
                object = set;
                if (set != null) break block2;
            }
            object = SetsKt.emptySet();
        }
        return object;
    }

    private final Event decodedEvent() {
        Event decodedEvent;
        Event localEvent = this.event;
        if (localEvent != null) {
            return localEvent;
        }
        File file = this.eventFile;
        Intrinsics.checkNotNull((Object)file);
        String string = this.apiKey;
        if (string == null) {
            string = this.config.getApiKey();
        }
        MarshalledEventSource eventSource = new MarshalledEventSource(file, string, this.getLogger());
        this.event = decodedEvent = eventSource.invoke();
        return decodedEvent;
    }

    @JvmOverloads
    @NotNull
    public final EventPayload trimToSize(int maxSizeBytes) {
        byte[] json = this.toByteArray();
        if (json.length <= maxSizeBytes) {
            return this;
        }
        Event event = this.decodedEvent();
        TrimMetrics trimMetrics = event.getImpl().trimMetadataStringsTo(this.config.getMaxStringValueLength());
        int itemsTrimmed = trimMetrics.component1();
        int dataTrimmed = trimMetrics.component2();
        event.getImpl().getInternalMetrics().setMetadataTrimMetrics(itemsTrimmed, dataTrimmed);
        int threadCount = event.getThreads().size();
        int maxReportedThreads = this.config.getMaxReportedThreads();
        if (threadCount > maxReportedThreads) {
            event.getThreads().subList(maxReportedThreads, threadCount).clear();
            StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{new StackTraceElement("", "", "-", 0)};
            event.getThreads().add(new Thread("", "" + '[' + (threadCount - maxReportedThreads) + " threads omitted as the maxReportedThreads limit (" + maxReportedThreads + ") was exceeded]", ErrorType.UNKNOWN, false, Thread.State.UNKNOWN, new Stacktrace(stackTraceElementArray, this.config.getProjectPackages(), this.getLogger()), this.getLogger()));
        }
        if ((json = this.rebuildPayloadCache$bugsnag_android_core_release()).length <= maxSizeBytes) {
            return this;
        }
        TrimMetrics breadcrumbAndBytesRemovedCounts = event.getImpl().trimBreadcrumbsBy(json.length - maxSizeBytes);
        event.getImpl().getInternalMetrics().setBreadcrumbTrimMetrics(breadcrumbAndBytesRemovedCounts.getItemsTrimmed(), breadcrumbAndBytesRemovedCounts.getDataTrimmed());
        this.rebuildPayloadCache$bugsnag_android_core_release();
        return this;
    }

    public static /* synthetic */ EventPayload trimToSize$default(EventPayload eventPayload, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 999700;
        }
        return eventPayload.trimToSize(n);
    }

    @Override
    public void toStream(@NotNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("apiKey").value(this.apiKey);
        writer.name("payloadVersion").value("4.0");
        writer.name("notifier").value(this.notifier);
        writer.name("events").beginArray();
        if (this.event != null) {
            writer.value(this.event);
        } else if (this.eventFile != null) {
            writer.value(this.eventFile);
        }
        writer.endArray();
        writer.endObject();
    }

    @Override
    @NotNull
    public byte[] toByteArray() throws IOException {
        byte[] payload = this.cachedBytes;
        if (payload == null) {
            this.cachedBytes = payload = JsonHelper.INSTANCE.serialize(this);
        }
        return payload;
    }

    @VisibleForTesting
    @NotNull
    public final byte[] rebuildPayloadCache$bugsnag_android_core_release() {
        this.cachedBytes = null;
        return this.toByteArray();
    }

    @Override
    @Nullable
    public String getIntegrityToken() {
        return Deliverable.DefaultImpls.getIntegrityToken(this);
    }

    @JvmOverloads
    public EventPayload(@Nullable String apiKey, @Nullable Event event, @NotNull Notifier notifier, @NotNull ImmutableConfig config) {
        this(apiKey, event, null, notifier, config, 4, null);
    }

    @JvmOverloads
    public EventPayload(@Nullable String apiKey, @NotNull Notifier notifier, @NotNull ImmutableConfig config) {
        this(apiKey, null, null, notifier, config, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final EventPayload trimToSize() {
        return EventPayload.trimToSize$default(this, 0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bugsnag/android/EventPayload$Companion;", "", "()V", "DEFAULT_MAX_PAYLOAD_SIZE", "", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

