/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.IOUtils;
import com.bugsnag.android.ObjectJsonStreamer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\u0010\u0004\n\u0002\b\u0004\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0002@AB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010 \u001a\u00020\u0000J\b\u0010!\u001a\u00020\u001dH\u0016J\"\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\b\u0010'\u001a\u00020\u001dH\u0016J\u0010\u0010(\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010*\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010\u000fJ\b\u0010+\u001a\u00020\u001dH\u0002J\u0006\u0010,\u001a\u00020\u0000J\u001a\u0010-\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001b2\b\u0010.\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010/\u001a\u00020\u001bH\u0002J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u001bH\u0002J\u0010\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001bH\u0002J\u000e\u00104\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u00105\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u000107J\u0010\u0010)\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u000109J\u0018\u0010)\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000bJ\u0015\u0010)\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010;J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020<J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020=J\u0010\u0010)\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010>J\u0010\u0010)\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u000fJ\b\u0010?\u001a\u00020\u001dH\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/bugsnag/android/JsonStream;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "out", "Ljava/io/Writer;", "(Ljava/io/Writer;)V", "stream", "streamer", "Lcom/bugsnag/android/ObjectJsonStreamer;", "(Lcom/bugsnag/android/JsonStream;Lcom/bugsnag/android/ObjectJsonStreamer;)V", "serializeNulls", "", "objectJsonStreamer", "(Ljava/io/Writer;ZLcom/bugsnag/android/ObjectJsonStreamer;)V", "deferredName", "", "indent", "isHtmlSafe", "()Z", "setHtmlSafe", "(Z)V", "isLenient", "setLenient", "separator", "stack", "", "stackSize", "", "beforeName", "", "beforeValue", "beginArray", "beginObject", "close", "empty", "nonempty", "closeBracket", "endArray", "endObject", "flush", "jsonValue", "value", "name", "newline", "nullValue", "open", "openBracket", "peek", "push", "newTop", "replaceTop", "topOfStack", "setIndent", "string", "file", "Ljava/io/File;", "obj", "", "shouldRedactKeys", "(Ljava/lang/Boolean;)Lcom/bugsnag/android/JsonStream;", "", "", "", "writeDeferredName", "Companion", "Streamable", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nJsonStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonStream.kt\ncom/bugsnag/android/JsonStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,588:1\n1#2:589\n*E\n"})
public final class JsonStream
implements Closeable,
Flushable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Writer out;
    private final boolean serializeNulls;
    @NotNull
    private final ObjectJsonStreamer objectJsonStreamer;
    @NotNull
    private int[] stack;
    private int stackSize;
    @Nullable
    private String indent;
    @NotNull
    private String separator;
    private boolean isLenient;
    private boolean isHtmlSafe;
    @Nullable
    private String deferredName;
    @NotNull
    private static final String[] REPLACEMENT_CHARS = new String[128];
    @NotNull
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;

    private JsonStream(Writer out, boolean serializeNulls, ObjectJsonStreamer objectJsonStreamer) {
        this.out = out;
        this.serializeNulls = serializeNulls;
        this.objectJsonStreamer = objectJsonStreamer;
        this.stack = new int[32];
        this.push(6);
        this.separator = ":";
    }

    public final boolean isLenient() {
        return this.isLenient;
    }

    public final void setLenient(boolean bl) {
        this.isLenient = bl;
    }

    public final boolean isHtmlSafe() {
        return this.isHtmlSafe;
    }

    public final void setHtmlSafe(boolean bl) {
        this.isHtmlSafe = bl;
    }

    public JsonStream(@NotNull Writer out) {
        this(out, false, new ObjectJsonStreamer());
    }

    public JsonStream(@NotNull JsonStream stream, @NotNull ObjectJsonStreamer streamer) {
        this(stream.out, stream.serializeNulls, streamer);
    }

    public final void setIndent(@NotNull String indent) {
        if (((CharSequence)indent).length() == 0) {
            this.indent = null;
            this.separator = ":";
        } else {
            this.indent = indent;
            this.separator = ": ";
        }
    }

    @NotNull
    public final JsonStream beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, "[");
    }

    @NotNull
    public final JsonStream endArray() throws IOException {
        return this.close(1, 2, "]");
    }

    @NotNull
    public final JsonStream beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, "{");
    }

    @NotNull
    public final JsonStream endObject() throws IOException {
        return this.close(3, 5, "}");
    }

    private final JsonStream open(int empty, String openBracket) throws IOException {
        this.beforeValue();
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private final JsonStream close(int empty, int nonempty, String closeBracket) throws IOException {
        int context = this.peek();
        if (!(context == nonempty || context == empty)) {
            boolean $i$a$-check-JsonStream$close$32 = false;
            String $i$a$-check-JsonStream$close$32 = "Nesting problem.";
            throw new IllegalStateException($i$a$-check-JsonStream$close$32.toString());
        }
        if (!(this.deferredName == null)) {
            boolean bl = false;
            String string = "Dangling name: " + this.deferredName;
            throw new IllegalStateException(string.toString());
        }
        int n = this.stackSize;
        this.stackSize = n + -1;
        if (context == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private final void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] newStack = new int[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            this.stack = newStack;
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
        this.stack[n] = newTop;
    }

    private final int peek() {
        if (!(this.stackSize != 0)) {
            boolean bl = false;
            String string = "JsonStream is closed.";
            throw new IllegalStateException(string.toString());
        }
        return this.stack[this.stackSize - 1];
    }

    private final void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    @NotNull
    public final JsonStream name(@Nullable String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (!(this.deferredName == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(this.stackSize != 0)) {
            boolean bl = false;
            String string = "JsonStream is closed.";
            throw new IllegalStateException(string.toString());
        }
        this.deferredName = name;
        return this;
    }

    private final void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            String string = this.deferredName;
            Intrinsics.checkNotNull((Object)string);
            this.string(string);
            this.deferredName = null;
        }
    }

    @NotNull
    public final JsonStream value(@Nullable String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(value);
        return this;
    }

    @NotNull
    public final JsonStream jsonValue(@Nullable String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value);
        return this;
    }

    @NotNull
    public final JsonStream nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    @NotNull
    public final JsonStream value(boolean value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value ? "true" : "false");
        return this;
    }

    @NotNull
    public final JsonStream value(@Nullable Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value != false ? "true" : "false");
        return this;
    }

    @NotNull
    public final JsonStream value(double value) throws IOException {
        if (!this.isLenient && (Double.isNaN(value) || Double.isInfinite(value))) {
            this.deferredName = null;
        } else {
            this.writeDeferredName();
            this.beforeValue();
            this.out.write(String.valueOf(value));
        }
        return this;
    }

    @NotNull
    public final JsonStream value(long value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(String.valueOf(value));
        return this;
    }

    @NotNull
    public final JsonStream value(@Nullable Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        String string = value.toString();
        if (!this.isLenient && (Intrinsics.areEqual((Object)string, (Object)"-Infinity") || Intrinsics.areEqual((Object)string, (Object)"Infinity") || Intrinsics.areEqual((Object)string, (Object)"NaN"))) {
            this.deferredName = null;
        } else {
            this.writeDeferredName();
            this.beforeValue();
            this.out.write(string);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (!(this.stackSize != 0)) {
            boolean bl = false;
            String string = "JsonStream is closed.";
            throw new IllegalStateException(string.toString());
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private final void string(String value) throws IOException {
        String[] replacements = this.isHtmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write("\"");
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            String replacement = null;
            if (c < '\u0080') {
                replacement = replacements[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement);
            last = i + 1;
        }
        if (last < length) {
            this.out.write(value, last, length - last);
        }
        this.out.write("\"");
    }

    private final void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write("\n");
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write(this.indent);
        }
    }

    private final void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (!(context == 3)) {
            boolean bl = false;
            String string = "Nesting problem.";
            throw new IllegalStateException(string.toString());
        }
        this.newline();
        this.replaceTop(4);
    }

    private final void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.isLenient) {
                    boolean bl = false;
                    String string = "JSON must have only one top-level value.";
                    throw new IllegalStateException(string.toString());
                }
                this.replaceTop(7);
                break;
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.out.write(44);
                this.newline();
                break;
            }
            case 4: {
                this.out.write(this.separator);
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    @NotNull
    public final JsonStream value(@Nullable Object obj, boolean shouldRedactKeys) throws IOException {
        if (obj instanceof Streamable) {
            ((Streamable)obj).toStream(this);
        } else {
            this.objectJsonStreamer.objectToStream(obj, this, shouldRedactKeys);
        }
        return this;
    }

    @NotNull
    public final JsonStream value(@Nullable Object obj) throws IOException {
        if (obj instanceof File) {
            this.value((File)obj);
        } else {
            this.value(obj, false);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JsonStream value(@Nullable File file) throws IOException {
        if (file == null || file.length() <= 0L) {
            return this;
        }
        this.out.flush();
        this.beforeValue();
        Reader input = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            input = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            IOUtils.copy(input, this.out);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
        this.out.flush();
        return this;
    }

    @NotNull
    public static final String[] getREPLACEMENT_CHARS$bugsnag_android_core_release() {
        return Companion.getREPLACEMENT_CHARS$bugsnag_android_core_release();
    }

    @NotNull
    public static final String[] getHTML_SAFE_REPLACEMENT_CHARS$bugsnag_android_core_release() {
        return Companion.getHTML_SAFE_REPLACEMENT_CHARS$bugsnag_android_core_release();
    }

    static {
        for (int i = 0; i < 32; ++i) {
            String string = "\\u%04x";
            Object[] objectArray = new Object[]{i};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(this, *args)");
        }
        JsonStream.REPLACEMENT_CHARS[34] = "\\\"";
        JsonStream.REPLACEMENT_CHARS[92] = "\\\\";
        JsonStream.REPLACEMENT_CHARS[9] = "\\t";
        JsonStream.REPLACEMENT_CHARS[8] = "\\b";
        JsonStream.REPLACEMENT_CHARS[10] = "\\n";
        JsonStream.REPLACEMENT_CHARS[13] = "\\r";
        JsonStream.REPLACEMENT_CHARS[12] = "\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        JsonStream.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c";
        JsonStream.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonStream.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonStream.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonStream.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\u0010\n\u0002\u0010\t\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR&\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\u0010\n\u0002\u0010\t\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Lcom/bugsnag/android/JsonStream$Companion;", "", "()V", "HTML_SAFE_REPLACEMENT_CHARS", "", "", "getHTML_SAFE_REPLACEMENT_CHARS$bugsnag_android_core_release$annotations", "getHTML_SAFE_REPLACEMENT_CHARS$bugsnag_android_core_release", "()[Ljava/lang/String;", "[Ljava/lang/String;", "REPLACEMENT_CHARS", "getREPLACEMENT_CHARS$bugsnag_android_core_release$annotations", "getREPLACEMENT_CHARS$bugsnag_android_core_release", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getREPLACEMENT_CHARS$bugsnag_android_core_release() {
            return REPLACEMENT_CHARS;
        }

        @JvmStatic
        public static /* synthetic */ void getREPLACEMENT_CHARS$bugsnag_android_core_release$annotations() {
        }

        @NotNull
        public final String[] getHTML_SAFE_REPLACEMENT_CHARS$bugsnag_android_core_release() {
            return HTML_SAFE_REPLACEMENT_CHARS;
        }

        @JvmStatic
        public static /* synthetic */ void getHTML_SAFE_REPLACEMENT_CHARS$bugsnag_android_core_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/bugsnag/android/JsonStream$Streamable;", "", "toStream", "", "writer", "Lcom/bugsnag/android/JsonStream;", "bugsnag-android-core_release"})
    public static interface Streamable {
        public void toStream(@NotNull JsonStream var1) throws IOException;
    }
}

