/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.BaseObservable;
import com.bugsnag.android.CallbackState;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeliveryStatus;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.EventStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.Session;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.internal.dag.Provider;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

class DeliveryDelegate
extends BaseObservable {
    @VisibleForTesting
    static long DELIVERY_TIMEOUT = 3000L;
    final Logger logger;
    private final Provider<EventStore> eventStore;
    private final ImmutableConfig immutableConfig;
    private final Notifier notifier;
    private final CallbackState callbackState;
    final BackgroundTaskService backgroundTaskService;

    DeliveryDelegate(Logger logger, Provider<EventStore> eventStore, ImmutableConfig immutableConfig, CallbackState callbackState, Notifier notifier, BackgroundTaskService backgroundTaskService) {
        this.logger = logger;
        this.eventStore = eventStore;
        this.immutableConfig = immutableConfig;
        this.callbackState = callbackState;
        this.notifier = notifier;
        this.backgroundTaskService = backgroundTaskService;
    }

    void deliver(@NonNull Event event) {
        this.logger.d("DeliveryDelegate#deliver() - event being stored/delivered by Client");
        Session session = event.getSession();
        if (session != null) {
            if (event.isUnhandled()) {
                event.setSession(session.incrementUnhandledAndCopy());
                this.updateState(StateEvent.NotifyUnhandled.INSTANCE);
            } else {
                event.setSession(session.incrementHandledAndCopy());
                this.updateState(StateEvent.NotifyHandled.INSTANCE);
            }
        }
        switch (event.getDeliveryStrategy()) {
            case STORE_AND_SEND: {
                this.cacheAndSendSynchronously(event);
                break;
            }
            case STORE_ONLY: {
                this.cacheEvent(event, false);
                break;
            }
            case SEND_IMMEDIATELY: {
                if (!this.callbackState.runOnSendTasks(event, this.logger)) break;
                String apiKey = event.getApiKey();
                EventPayload eventPayload = new EventPayload(apiKey, event, this.notifier, this.immutableConfig);
                this.deliverPayloadAsync(event, eventPayload);
                break;
            }
            default: {
                this.cacheEvent(event, true);
            }
        }
    }

    private void deliverPayloadAsync(@NonNull Event event, EventPayload eventPayload) {
        final EventPayload finalEventPayload = eventPayload;
        final Event finalEvent = event;
        try {
            this.backgroundTaskService.submitTask(TaskType.ERROR_REQUEST, new Runnable(){

                @Override
                public void run() {
                    DeliveryDelegate.this.deliverPayloadInternal(finalEventPayload, finalEvent);
                }
            });
        }
        catch (RejectedExecutionException exception) {
            this.cacheEvent(event, false);
            this.logger.w("Exceeded max queue count, saving to disk to send later");
        }
    }

    @VisibleForTesting
    DeliveryStatus deliverPayloadInternal(@NonNull EventPayload payload, @NonNull Event event) {
        this.logger.d("DeliveryDelegate#deliverPayloadInternal() - attempting event delivery");
        DeliveryParams deliveryParams = this.immutableConfig.getErrorApiDeliveryParams(payload);
        Delivery delivery = this.immutableConfig.getDelivery();
        DeliveryStatus deliveryStatus = delivery.deliver(payload, deliveryParams);
        switch (deliveryStatus) {
            case DELIVERED: {
                this.logger.i("Sent 1 new event to Bugsnag");
                break;
            }
            case UNDELIVERED: {
                this.logger.w("Could not send event(s) to Bugsnag, saving to disk to send later");
                this.cacheEvent(event, false);
                break;
            }
            case FAILURE: {
                this.logger.w("Problem sending event to Bugsnag");
                break;
            }
        }
        return deliveryStatus;
    }

    private void cacheAndSendSynchronously(@NonNull Event event) {
        long cutoffTime = System.currentTimeMillis() + DELIVERY_TIMEOUT;
        Future<String> task2 = this.eventStore().writeAndDeliver(event);
        long timeout = cutoffTime - System.currentTimeMillis();
        if (task2 != null && timeout > 0L) {
            try {
                task2.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                this.logger.w("failed to immediately deliver event", ex);
            }
            if (!task2.isDone()) {
                task2.cancel(true);
            }
        }
    }

    private void cacheEvent(@NonNull Event event, boolean attemptSend) {
        this.eventStore().write(event);
        if (attemptSend) {
            this.eventStore().flushAsync();
        }
    }

    private EventStore eventStore() {
        return this.eventStore.get();
    }
}

