/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import com.bugsnag.android.App;
import com.bugsnag.android.AppWithState;
import com.bugsnag.android.LaunchCrashTracker;
import com.bugsnag.android.MemoryTrimState;
import com.bugsnag.android.SessionTracker;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.dag.Provider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 82\u00020\u0001:\u00018BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\"\u001a\u0004\u0018\u00010#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0004\b%\u0010&J\n\u0010'\u001a\u0004\u0018\u00010\u0013H\u0003J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020+J\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010.J\n\u0010/\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u00100\u001a\u0004\u0018\u00010\u0013J\n\u00101\u001a\u0004\u0018\u00010\u0013H\u0003J\u000f\u00102\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u00103J\u001e\u00104\u001a\u0002052\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00010.H\u0002J\u000e\u00107\u001a\u0002052\u0006\u0010\u0017\u001a\u00020\u0013R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/bugsnag/android/AppDataCollector;", "", "appContext", "Landroid/content/Context;", "packageManager", "Landroid/content/pm/PackageManager;", "config", "Lcom/bugsnag/android/internal/ImmutableConfig;", "sessionTracker", "Lcom/bugsnag/android/internal/dag/Provider;", "Lcom/bugsnag/android/SessionTracker;", "activityManager", "Landroid/app/ActivityManager;", "launchCrashTracker", "Lcom/bugsnag/android/LaunchCrashTracker;", "memoryTrimState", "Lcom/bugsnag/android/MemoryTrimState;", "(Landroid/content/Context;Landroid/content/pm/PackageManager;Lcom/bugsnag/android/internal/ImmutableConfig;Lcom/bugsnag/android/internal/dag/Provider;Landroid/app/ActivityManager;Lcom/bugsnag/android/LaunchCrashTracker;Lcom/bugsnag/android/MemoryTrimState;)V", "appName", "", "bgWorkRestricted", "", "Ljava/lang/Boolean;", "binaryArch", "codeBundleId", "getCodeBundleId", "()Ljava/lang/String;", "setCodeBundleId", "(Ljava/lang/String;)V", "installerPackage", "packageName", "processName", "releaseStage", "versionName", "calculateDurationInForeground", "", "inForeground", "calculateDurationInForeground$bugsnag_android_core_release", "(Ljava/lang/Boolean;)Ljava/lang/Long;", "findProcessName", "generateApp", "Lcom/bugsnag/android/App;", "generateAppWithState", "Lcom/bugsnag/android/AppWithState;", "generateHistoricAppWithState", "getAppDataMetadata", "", "getAppName", "getInstallerPackageName", "getProcessImportance", "isBackgroundWorkRestricted", "()Ljava/lang/Boolean;", "populateRuntimeMemoryMetadata", "", "map", "setBinaryArch", "Companion", "bugsnag-android-core_release"})
public final class AppDataCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PackageManager packageManager;
    @NotNull
    private final ImmutableConfig config;
    @NotNull
    private final Provider<SessionTracker> sessionTracker;
    @Nullable
    private final ActivityManager activityManager;
    @NotNull
    private final LaunchCrashTracker launchCrashTracker;
    @NotNull
    private final MemoryTrimState memoryTrimState;
    @Nullable
    private String codeBundleId;
    @NotNull
    private final String packageName;
    @Nullable
    private final Boolean bgWorkRestricted;
    @Nullable
    private String binaryArch;
    @Nullable
    private final String appName;
    @Nullable
    private final String processName;
    @Nullable
    private final String releaseStage;
    @Nullable
    private final String versionName;
    @Nullable
    private final String installerPackage;
    private static final long startTimeMs = SystemClock.elapsedRealtime();
    private static final int IMPORTANCE_CANT_SAVE_STATE_PRE_26 = 170;

    public AppDataCollector(@NotNull Context appContext, @Nullable PackageManager packageManager, @NotNull ImmutableConfig config, @NotNull Provider<SessionTracker> sessionTracker, @Nullable ActivityManager activityManager, @NotNull LaunchCrashTracker launchCrashTracker, @NotNull MemoryTrimState memoryTrimState) {
        this.packageManager = packageManager;
        this.config = config;
        this.sessionTracker = sessionTracker;
        this.activityManager = activityManager;
        this.launchCrashTracker = launchCrashTracker;
        this.memoryTrimState = memoryTrimState;
        this.packageName = appContext.getPackageName();
        this.bgWorkRestricted = this.isBackgroundWorkRestricted();
        this.appName = this.getAppName();
        this.processName = this.findProcessName();
        this.releaseStage = this.config.getReleaseStage();
        String string = this.config.getAppVersion();
        if (string == null) {
            PackageInfo packageInfo = this.config.getPackageInfo();
            string = packageInfo != null ? packageInfo.versionName : null;
        }
        this.versionName = string;
        this.installerPackage = this.getInstallerPackageName();
    }

    @Nullable
    public final String getCodeBundleId() {
        return this.codeBundleId;
    }

    public final void setCodeBundleId(@Nullable String string) {
        this.codeBundleId = string;
    }

    @NotNull
    public final App generateApp() {
        return new App(this.config, this.binaryArch, this.packageName, this.releaseStage, this.versionName, this.codeBundleId);
    }

    @NotNull
    public final AppWithState generateAppWithState() {
        boolean inForeground = this.sessionTracker.get().isInForeground();
        Long durationInForeground = this.calculateDurationInForeground$bugsnag_android_core_release(inForeground);
        return new AppWithState(this.config, this.binaryArch, this.packageName, this.releaseStage, this.versionName, this.codeBundleId, Companion.getDurationMs(), durationInForeground, inForeground, this.launchCrashTracker.isLaunching());
    }

    @NotNull
    public final AppWithState generateHistoricAppWithState() {
        return new AppWithState(this.config, this.binaryArch, this.packageName, this.releaseStage, this.versionName, this.codeBundleId, null, null, null, null);
    }

    @SuppressLint(value={"SwitchIntDef"})
    private final String getProcessImportance() {
        try {
            String string;
            ActivityManager.RunningAppProcessInfo appInfo = new ActivityManager.RunningAppProcessInfo();
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appInfo);
            if (appInfo.pid == 0) {
                return null;
            }
            switch (appInfo.importance) {
                case 100: {
                    string = "foreground";
                    break;
                }
                case 125: {
                    string = "foreground service";
                    break;
                }
                case 325: {
                    string = "top sleeping";
                    break;
                }
                case 150: {
                    string = "top sleeping";
                    break;
                }
                case 200: {
                    string = "visible";
                    break;
                }
                case 230: {
                    string = "perceptible";
                    break;
                }
                case 130: {
                    string = "perceptible";
                    break;
                }
                case 350: {
                    string = "can't save state";
                    break;
                }
                case 170: {
                    string = "can't save state";
                    break;
                }
                case 300: {
                    string = "service";
                    break;
                }
                case 400: {
                    string = "cached/background";
                    break;
                }
                case 1000: {
                    string = "gone";
                    break;
                }
                case 500: {
                    string = "empty";
                    break;
                }
                case 1: {
                    string = "provider in use";
                    break;
                }
                case 2: {
                    string = "service in use";
                    break;
                }
                default: {
                    string = "unknown importance (" + appInfo.importance + ')';
                }
            }
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public final Map<String, Object> getAppDataMetadata() {
        HashMap map2;
        block2: {
            map2 = new HashMap();
            ((Map)map2).put("name", this.appName);
            ((Map)map2).put("activeScreen", this.sessionTracker.get().getContextActivity());
            ((Map)map2).put("processImportance", this.getProcessImportance());
            if (this.memoryTrimState.getMemoryTrimLevel() != null) {
                ((Map)map2).put("lowMemory", this.memoryTrimState.isLowMemory());
                ((Map)map2).put("memoryTrimLevel", this.memoryTrimState.getTrimLevelDescription());
            }
            this.populateRuntimeMemoryMetadata(map2);
            Boolean bl = this.bgWorkRestricted;
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                ((Map)map2).put("backgroundWorkRestricted", this.bgWorkRestricted);
            }
            String string = this.processName;
            if (string == null) break block2;
            String it = string;
            boolean bl3 = false;
            ((Map)map2).put("processName", it);
        }
        return map2;
    }

    private final void populateRuntimeMemoryMetadata(Map<String, Object> map2) {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        map2.put("memoryUsage", totalMemory - freeMemory);
        Long l = totalMemory;
        map2.put("totalMemory", l);
        l = freeMemory;
        map2.put("freeMemory", l);
        map2.put("memoryLimit", runtime.maxMemory());
        map2.put("installerPackage", this.installerPackage);
    }

    private final Boolean isBackgroundWorkRestricted() {
        return this.activityManager == null || Build.VERSION.SDK_INT < 28 ? null : (this.activityManager.isBackgroundRestricted() ? Boolean.valueOf(true) : null);
    }

    public final void setBinaryArch(@NotNull String binaryArch) {
        this.binaryArch = binaryArch;
    }

    @Nullable
    public final Long calculateDurationInForeground$bugsnag_android_core_release(@Nullable Boolean inForeground) {
        if (inForeground == null) {
            return null;
        }
        long nowMs = SystemClock.elapsedRealtime();
        long durationMs = 0L;
        long sessionStartTimeMs = this.sessionTracker.get().getLastEnteredForegroundMs();
        if (inForeground.booleanValue() && sessionStartTimeMs != 0L) {
            durationMs = nowMs - sessionStartTimeMs;
        }
        return durationMs > 0L ? Long.valueOf(durationMs) : Long.valueOf(0L);
    }

    public static /* synthetic */ Long calculateDurationInForeground$bugsnag_android_core_release$default(AppDataCollector appDataCollector, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = appDataCollector.sessionTracker.get().isInForeground();
        }
        return appDataCollector.calculateDurationInForeground$bugsnag_android_core_release(bl);
    }

    private final String getAppName() {
        ApplicationInfo copy = this.config.getAppInfo();
        return this.packageManager != null && copy != null ? ((Object)this.packageManager.getApplicationLabel(copy)).toString() : null;
    }

    @Nullable
    public final String getInstallerPackageName() {
        try {
            if (Build.VERSION.SDK_INT >= 30) {
                PackageManager packageManager = this.packageManager;
                return packageManager != null && (packageManager = packageManager.getInstallSourceInfo(this.packageName)) != null ? packageManager.getInstallingPackageName() : null;
            }
            PackageManager packageManager = this.packageManager;
            return packageManager != null ? packageManager.getInstallerPackageName(this.packageName) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private final String findProcessName() {
        Object object;
        Object object2 = this;
        try {
            String string;
            AppDataCollector $this$findProcessName_u24lambda_u242 = object2;
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 28) {
                string = Application.getProcessName();
            } else {
                Class<?> clz = Class.forName("android.app.ActivityThread");
                String methodName = Build.VERSION.SDK_INT >= 18 ? "currentProcessName" : "currentPackageName";
                Method getProcessName = clz.getDeclaredMethod(methodName, new Class[0]);
                Object object3 = getProcessName.invoke(null, new Object[0]);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
                string = (String)object3;
            }
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/bugsnag/android/AppDataCollector$Companion;", "", "()V", "IMPORTANCE_CANT_SAVE_STATE_PRE_26", "", "startTimeMs", "", "getStartTimeMs$bugsnag_android_core_release", "()J", "getDurationMs", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getStartTimeMs$bugsnag_android_core_release() {
            return startTimeMs;
        }

        public final long getDurationMs() {
            return SystemClock.elapsedRealtime() - this.getStartTimeMs$bugsnag_android_core_release();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

