/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.os.SystemClock;
import com.bugsnag.android.CallbackState;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeliveryStatus;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventFilenameInfo;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.EventStore;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.LastRunInfo;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MarshalledEventSource;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.ForegroundDetector;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.internal.dag.Provider;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 H2\u00020\u0001:\u0001HBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\u0016H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010*\u001a\u0004\u0018\u00010$2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020$0,J\u0006\u0010-\u001a\u00020\u0017J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010/\u001a\u00020\u0017H\u0002J\u0010\u00100\u001a\u00020\u00172\b\u00101\u001a\u0004\u0018\u000102J\u0016\u00103\u001a\u00020\u00172\f\u00104\u001a\b\u0012\u0004\u0012\u00020$0,H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020$H\u0002J\u0012\u00108\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u00010:H\u0016J\u001a\u0010;\u001a\u00020&2\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010%\u001a\u0004\u0018\u00010&J\u001c\u0010<\u001a\u00020\u00172\n\u0010=\u001a\u00060>j\u0002`?2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010@\u001a\u00020\u00112\u0006\u00107\u001a\u00020$H\u0002J\u0010\u0010A\u001a\u00020\u00112\u0006\u00107\u001a\u00020$H\u0002J\b\u0010B\u001a\u00020\u0017H\u0002J\u0010\u0010C\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010D\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010E2\u0006\u0010F\u001a\u00020GR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006I"}, d2={"Lcom/bugsnag/android/EventStore;", "Lcom/bugsnag/android/FileStore;", "config", "Lcom/bugsnag/android/internal/ImmutableConfig;", "logger", "Lcom/bugsnag/android/Logger;", "notifier", "Lcom/bugsnag/android/Notifier;", "bgTaskService", "Lcom/bugsnag/android/internal/BackgroundTaskService;", "delegate", "Lcom/bugsnag/android/internal/dag/Provider;", "Lcom/bugsnag/android/FileStore$Delegate;", "callbackState", "Lcom/bugsnag/android/CallbackState;", "(Lcom/bugsnag/android/internal/ImmutableConfig;Lcom/bugsnag/android/Logger;Lcom/bugsnag/android/Notifier;Lcom/bugsnag/android/internal/BackgroundTaskService;Lcom/bugsnag/android/internal/dag/Provider;Lcom/bugsnag/android/CallbackState;)V", "isEmptyEventCallbackCalled", "", "getLogger", "()Lcom/bugsnag/android/Logger;", "onDiscardEventCallback", "Lkotlin/Function1;", "Lcom/bugsnag/android/EventPayload;", "", "getOnDiscardEventCallback", "()Lkotlin/jvm/functions/Function1;", "setOnDiscardEventCallback", "(Lkotlin/jvm/functions/Function1;)V", "onEventStoreEmptyCallback", "Lkotlin/Function0;", "getOnEventStoreEmptyCallback", "()Lkotlin/jvm/functions/Function0;", "setOnEventStoreEmptyCallback", "(Lkotlin/jvm/functions/Function0;)V", "createEventPayload", "eventFile", "Ljava/io/File;", "apiKey", "", "deliverEventPayload", "payload", "discardEvents", "findLaunchCrashReport", "storedFiles", "", "flushAsync", "flushEventFile", "flushLaunchCrashReport", "flushOnLaunch", "lastRunInfo", "Lcom/bugsnag/android/LastRunInfo;", "flushReports", "storedReports", "getCreationDate", "Ljava/util/Date;", "file", "getFilename", "obj", "", "getNdkFilename", "handleEventFlushFailure", "exc", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isTooBig", "isTooOld", "notifyEventQueueEmpty", "undeliveredEventPayload", "writeAndDeliver", "Ljava/util/concurrent/Future;", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "Companion", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nEventStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventStore.kt\ncom/bugsnag/android/EventStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1#2:309\n*E\n"})
public final class EventStore
extends FileStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig config;
    @NotNull
    private final Notifier notifier;
    @NotNull
    private final BackgroundTaskService bgTaskService;
    @NotNull
    private final CallbackState callbackState;
    @NotNull
    private final Logger logger;
    @NotNull
    private Function0<Unit> onEventStoreEmptyCallback;
    @NotNull
    private Function1<? super EventPayload, Unit> onDiscardEventCallback;
    private boolean isEmptyEventCallbackCalled;
    private static final long LAUNCH_CRASH_TIMEOUT_MS = 2000L;
    @NotNull
    private static final Comparator<? super File> EVENT_COMPARATOR = EventStore::EVENT_COMPARATOR$lambda$6;
    private static final long oneMegabyte = 0x100000L;

    public EventStore(@NotNull ImmutableConfig config, @NotNull Logger logger, @NotNull Notifier notifier, @NotNull BackgroundTaskService bgTaskService, @Nullable Provider<? extends FileStore.Delegate> delegate, @NotNull CallbackState callbackState) {
        super(new File((File)config.getPersistenceDirectory().getValue(), "bugsnag/errors"), config.getMaxPersistedEvents(), logger, delegate);
        this.config = config;
        this.onEventStoreEmptyCallback = onEventStoreEmptyCallback.1.INSTANCE;
        this.onDiscardEventCallback = onDiscardEventCallback.1.INSTANCE;
        this.logger = logger;
        this.notifier = notifier;
        this.bgTaskService = bgTaskService;
        this.callbackState = callbackState;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Function0<Unit> getOnEventStoreEmptyCallback() {
        return this.onEventStoreEmptyCallback;
    }

    public final void setOnEventStoreEmptyCallback(@NotNull Function0<Unit> function0) {
        this.onEventStoreEmptyCallback = function0;
    }

    @NotNull
    public final Function1<EventPayload, Unit> getOnDiscardEventCallback() {
        return this.onDiscardEventCallback;
    }

    public final void setOnDiscardEventCallback(@NotNull Function1<? super EventPayload, Unit> function1) {
        this.onDiscardEventCallback = function1;
    }

    public final void flushOnLaunch(@Nullable LastRunInfo lastRunInfo) {
        Future<?> future;
        if (!this.config.getSendLaunchCrashesSynchronously()) {
            return;
        }
        try {
            future = this.bgTaskService.submitTask(TaskType.ERROR_REQUEST, () -> EventStore.flushOnLaunch$lambda$0(this));
        }
        catch (RejectedExecutionException exc) {
            this.getLogger().d("Failed to flush launch crash reports, continuing.", exc);
            return;
        }
        Future<?> future2 = future;
        LastRunInfo lastRunInfo2 = lastRunInfo;
        if (!(lastRunInfo2 != null ? lastRunInfo2.getCrashedDuringLaunch() : false)) {
            return;
        }
        try {
            long startupDuration = SystemClock.elapsedRealtime() - ForegroundDetector.INSTANCE.getStartupTime$bugsnag_android_core_release();
            long timeout = 2000L - startupDuration;
            if (!(0L <= timeout ? timeout < 2001L : false)) {
                return;
            }
            future2.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException exc) {
            this.getLogger().d("Failed to send launch crash reports within timeout, continuing.", exc);
        }
        catch (ExecutionException exc) {
            this.getLogger().d("Failed to send launch crash reports within timeout, continuing.", exc);
        }
        catch (TimeoutException exc) {
            this.getLogger().d("Failed to send launch crash reports within timeout, continuing.", exc);
        }
    }

    private final void flushLaunchCrashReport() {
        File launchCrashReport;
        List<File> storedFiles = this.findStoredFiles();
        File file = launchCrashReport = this.findLaunchCrashReport((Collection<? extends File>)storedFiles);
        if (file != null) {
            File it = file;
            boolean bl = false;
            storedFiles.remove(it);
        }
        this.cancelQueuedFiles((Collection<? extends File>)storedFiles);
        if (launchCrashReport != null) {
            this.getLogger().i("Attempting to send the most recent launch crash report");
            this.flushReports(CollectionsKt.listOf((Object)launchCrashReport));
            this.getLogger().i("Continuing with Bugsnag initialisation");
        } else {
            this.getLogger().d("No startupcrash events to flush to Bugsnag.");
        }
    }

    @Nullable
    public final File findLaunchCrashReport(@NotNull Collection<? extends File> storedFiles) {
        return (File)SequencesKt.maxWithOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)storedFiles), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ EventStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                return EventFilenameInfo.Companion.fromFile(it, EventStore.access$getConfig$p(this.this$0)).isLaunchCrashReport();
            }
        })), EVENT_COMPARATOR);
    }

    @Nullable
    public final Future<String> writeAndDeliver(@NotNull JsonStream.Streamable streamable) {
        String string = this.write(streamable);
        if (string == null) {
            return null;
        }
        String filename = string;
        try {
            return this.bgTaskService.submitTask(TaskType.ERROR_REQUEST, () -> EventStore.writeAndDeliver$lambda$2(this, filename));
        }
        catch (RejectedExecutionException exception) {
            this.getLogger().w("Failed to flush all on-disk errors, retaining unsent errors for later.");
            return null;
        }
    }

    public final void flushAsync() {
        try {
            this.bgTaskService.submitTask(TaskType.ERROR_REQUEST, () -> EventStore.flushAsync$lambda$3(this));
        }
        catch (RejectedExecutionException exception) {
            this.getLogger().w("Failed to flush all on-disk errors, retaining unsent errors for later.");
        }
    }

    private final void flushReports(Collection<? extends File> storedReports) {
        if (!storedReports.isEmpty()) {
            int size = storedReports.size();
            this.getLogger().i("Sending " + size + " saved error(s) to Bugsnag");
            for (File file : storedReports) {
                this.flushEventFile(file);
            }
        }
    }

    private final void flushEventFile(File eventFile) {
        try {
            String apiKey = EventFilenameInfo.Companion.fromFile(eventFile, this.config).component1();
            EventPayload payload = this.createEventPayload(eventFile, apiKey);
            if (payload == null) {
                this.deleteStoredFiles(SetsKt.setOf((Object)eventFile));
            } else {
                this.deliverEventPayload(eventFile, payload);
            }
        }
        catch (Exception exception) {
            this.handleEventFlushFailure(exception, eventFile);
        }
    }

    private final void deliverEventPayload(File eventFile, EventPayload payload) {
        DeliveryParams deliveryParams = this.config.getErrorApiDeliveryParams(payload);
        Delivery delivery = this.config.getDelivery();
        switch (WhenMappings.$EnumSwitchMapping$0[delivery.deliver(payload, deliveryParams).ordinal()]) {
            case 1: {
                this.deleteStoredFiles(SetsKt.setOf((Object)eventFile));
                this.getLogger().i("Deleting sent error file " + eventFile + ".name");
                break;
            }
            case 2: {
                this.undeliveredEventPayload(eventFile);
                break;
            }
            case 3: {
                Exception exc = new RuntimeException("Failed to deliver event payload");
                this.handleEventFlushFailure(exc, eventFile);
            }
        }
    }

    private final void undeliveredEventPayload(File eventFile) {
        if (this.isTooBig(eventFile)) {
            this.getLogger().w("Discarding over-sized event (" + eventFile.length() + ") after failed delivery");
            this.discardEvents(eventFile);
            this.deleteStoredFiles(SetsKt.setOf((Object)eventFile));
        } else if (this.isTooOld(eventFile)) {
            this.getLogger().w("Discarding historical event (from " + this.getCreationDate(eventFile) + ") after failed delivery");
            this.discardEvents(eventFile);
            this.deleteStoredFiles(SetsKt.setOf((Object)eventFile));
        } else {
            this.cancelQueuedFiles(SetsKt.setOf((Object)eventFile));
            this.getLogger().w("Could not send previously saved error(s) to Bugsnag, will try again later");
        }
    }

    private final EventPayload createEventPayload(File eventFile, String apiKey) {
        EventPayload eventPayload;
        String apiKey2;
        String string = apiKey2 = apiKey;
        Intrinsics.checkNotNull((Object)string);
        MarshalledEventSource eventSource = new MarshalledEventSource(eventFile, string, this.getLogger());
        try {
            if (!this.callbackState.runOnSendTasks((Function0<? extends Event>)((Function0)eventSource), this.getLogger())) {
                return null;
            }
        }
        catch (Exception ioe) {
            this.getLogger().w("could not parse event payload", ioe);
            eventSource.clear();
        }
        Event processedEvent = eventSource.getEvent();
        if (processedEvent != null) {
            apiKey2 = processedEvent.getApiKey();
            eventPayload = new EventPayload(apiKey2, processedEvent, null, this.notifier, this.config);
        } else {
            eventPayload = new EventPayload(apiKey2, null, eventFile, this.notifier, this.config);
        }
        return eventPayload;
    }

    private final void handleEventFlushFailure(Exception exc, File eventFile) {
        Logger logger = this.getLogger();
        String string = exc.getMessage();
        if (string == null) {
            string = "Failed to send event";
        }
        logger.e(string, exc);
        this.deleteStoredFiles(SetsKt.setOf((Object)eventFile));
    }

    @Override
    @NotNull
    public String getFilename(@Nullable Object obj) {
        Object object;
        block3: {
            block2: {
                object = obj;
                if (object == null) break block2;
                Object it = object;
                boolean bl = false;
                EventFilenameInfo eventFilenameInfo = EventFilenameInfo.Companion.fromEvent$default(EventFilenameInfo.Companion, it, null, null, 0L, this.config, null, 42, null);
                object = eventFilenameInfo;
                if (eventFilenameInfo != null && (object = ((EventFilenameInfo)object).encode()) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getNdkFilename(@Nullable Object obj, @Nullable String apiKey) {
        Object object;
        block3: {
            block2: {
                object = obj;
                if (object == null) break block2;
                Object it = object;
                boolean bl = false;
                EventFilenameInfo eventFilenameInfo = EventFilenameInfo.Companion.fromEvent$default(EventFilenameInfo.Companion, it, null, apiKey, 0L, this.config, null, 42, null);
                object = eventFilenameInfo;
                if (eventFilenameInfo != null && (object = ((EventFilenameInfo)object).encode()) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final boolean isTooBig(File file) {
        return file.length() > 0x100000L;
    }

    private final boolean isTooOld(File file) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -60);
        return EventFilenameInfo.Companion.findTimestampInFilename(file) < cal.getTimeInMillis();
    }

    private final Date getCreationDate(File file) {
        return new Date(EventFilenameInfo.Companion.findTimestampInFilename(file));
    }

    private final void notifyEventQueueEmpty() {
        if (this.isEmpty() && !this.isEmptyEventCallbackCalled) {
            this.onEventStoreEmptyCallback.invoke();
            this.isEmptyEventCallbackCalled = true;
        }
    }

    private final void discardEvents(File eventFile) {
        EventFilenameInfo eventFilenameInfo = EventFilenameInfo.Companion.fromFile(eventFile, this.config);
        this.onDiscardEventCallback.invoke((Object)new EventPayload(eventFilenameInfo.getApiKey(), null, eventFile, this.notifier, this.config));
    }

    private static final void flushOnLaunch$lambda$0(EventStore this$0) {
        this$0.flushLaunchCrashReport();
        this$0.notifyEventQueueEmpty();
    }

    private static final String writeAndDeliver$lambda$2(EventStore this$0, String $filename) {
        this$0.flushEventFile(new File($filename));
        return $filename;
    }

    private static final void flushAsync$lambda$3(EventStore this$0) {
        List<File> storedFiles = this$0.findStoredFiles();
        if (storedFiles.isEmpty()) {
            this$0.getLogger().d("No regular events to flush to Bugsnag.");
        }
        this$0.flushReports((Collection<? extends File>)storedFiles);
        this$0.notifyEventQueueEmpty();
    }

    private static final int EVENT_COMPARATOR$lambda$6(File lhs, File rhs) {
        return lhs == null && rhs == null ? 0 : (lhs == null ? 1 : (rhs == null ? -1 : lhs.compareTo(rhs)));
    }

    public static final /* synthetic */ ImmutableConfig access$getConfig$p(EventStore $this) {
        return $this.config;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R)\u0010\u0003\u001a\u001a\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00050\u0004j\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/bugsnag/android/EventStore$Companion;", "", "()V", "EVENT_COMPARATOR", "Ljava/util/Comparator;", "Ljava/io/File;", "Lkotlin/Comparator;", "getEVENT_COMPARATOR", "()Ljava/util/Comparator;", "LAUNCH_CRASH_TIMEOUT_MS", "", "oneMegabyte", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<? super File> getEVENT_COMPARATOR() {
            return EVENT_COMPARATOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeliveryStatus.values().length];
            try {
                nArray[DeliveryStatus.DELIVERED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeliveryStatus.UNDELIVERED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeliveryStatus.FAILURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

