/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Session;
import java.io.File;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010\u0013\u001a\u00020\u0003J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/bugsnag/android/SessionFilenameInfo;", "", "apiKey", "", "timestamp", "", "uuid", "(Ljava/lang/String;JLjava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "getTimestamp", "()J", "getUuid", "component1", "component2", "component3", "copy", "encode", "equals", "", "other", "hashCode", "", "toString", "Companion", "bugsnag-android-core_release"})
public final class SessionFilenameInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String apiKey;
    private final long timestamp;
    @NotNull
    private final String uuid;
    public static final int uuidLength = 36;

    public SessionFilenameInfo(@NotNull String apiKey, long timestamp, @NotNull String uuid) {
        this.apiKey = apiKey;
        this.timestamp = timestamp;
        this.uuid = uuid;
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@NotNull String string) {
        this.apiKey = string;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final String getUuid() {
        return this.uuid;
    }

    @NotNull
    public final String encode() {
        return Companion.toFilename(this.apiKey, this.timestamp, this.uuid);
    }

    @NotNull
    public final String component1() {
        return this.apiKey;
    }

    public final long component2() {
        return this.timestamp;
    }

    @NotNull
    public final String component3() {
        return this.uuid;
    }

    @NotNull
    public final SessionFilenameInfo copy(@NotNull String apiKey, long timestamp, @NotNull String uuid) {
        return new SessionFilenameInfo(apiKey, timestamp, uuid);
    }

    public static /* synthetic */ SessionFilenameInfo copy$default(SessionFilenameInfo sessionFilenameInfo, String string, long l, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = sessionFilenameInfo.apiKey;
        }
        if ((n & 2) != 0) {
            l = sessionFilenameInfo.timestamp;
        }
        if ((n & 4) != 0) {
            string2 = sessionFilenameInfo.uuid;
        }
        return sessionFilenameInfo.copy(string, l, string2);
    }

    @NotNull
    public String toString() {
        return "SessionFilenameInfo(apiKey=" + this.apiKey + ", timestamp=" + this.timestamp + ", uuid=" + this.uuid + ')';
    }

    public int hashCode() {
        int result = this.apiKey.hashCode();
        result = result * 31 + Long.hashCode(this.timestamp);
        result = result * 31 + this.uuid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SessionFilenameInfo)) {
            return false;
        }
        SessionFilenameInfo sessionFilenameInfo = (SessionFilenameInfo)other;
        if (!Intrinsics.areEqual((Object)this.apiKey, (Object)sessionFilenameInfo.apiKey)) {
            return false;
        }
        if (this.timestamp != sessionFilenameInfo.timestamp) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uuid, (Object)sessionFilenameInfo.uuid);
    }

    @JvmStatic
    @NotNull
    public static final SessionFilenameInfo defaultFilename(@Nullable Object obj, @NotNull String apiKey) {
        return Companion.defaultFilename(obj, apiKey);
    }

    @JvmStatic
    @NotNull
    public static final String findUuidInFilename(@NotNull File file) {
        return Companion.findUuidInFilename(file);
    }

    @JvmStatic
    public static final long findTimestampInFilename(@NotNull File file) {
        return Companion.findTimestampInFilename(file);
    }

    @JvmStatic
    @NotNull
    public static final String findApiKeyInFilename(@Nullable File file, @NotNull String defaultApiKey) {
        return Companion.findApiKeyInFilename(file, defaultApiKey);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0014J\u001e\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/bugsnag/android/SessionFilenameInfo$Companion;", "", "()V", "uuidLength", "", "defaultFilename", "Lcom/bugsnag/android/SessionFilenameInfo;", "obj", "apiKey", "", "findApiKeyInFilename", "file", "Ljava/io/File;", "defaultApiKey", "findTimestampInFilename", "", "findUuidInFilename", "fromFile", "isFileV3", "", "isFileV3$bugsnag_android_core_release", "toFilename", "timestamp", "uuid", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toFilename(@NotNull String apiKey, long timestamp, @NotNull String uuid) {
            return apiKey + '_' + uuid + timestamp + "_v3.json";
        }

        @JvmStatic
        @NotNull
        public final SessionFilenameInfo defaultFilename(@Nullable Object obj, @NotNull String apiKey) {
            String sanitizedApiKey = obj instanceof Session ? ((Session)obj).getApiKey() : apiKey;
            return new SessionFilenameInfo(sanitizedApiKey, System.currentTimeMillis(), UUID.randomUUID().toString());
        }

        @NotNull
        public final SessionFilenameInfo fromFile(@NotNull File file, @NotNull String defaultApiKey) {
            return new SessionFilenameInfo(this.findApiKeyInFilename(file, defaultApiKey), this.findTimestampInFilename(file), this.findUuidInFilename(file));
        }

        @JvmStatic
        @NotNull
        public final String findUuidInFilename(@NotNull File file) {
            String string;
            String string2;
            String fileName = file.getName();
            if (this.isFileV3$bugsnag_android_core_release(file)) {
                fileName = StringsKt.substringAfter$default((String)file.getName(), (char)'_', null, (int)2, null);
            }
            String it = string2 = fileName;
            boolean bl = false;
            String string3 = it.length() >= 36 ? string2 : null;
            if (string3 == null) {
                string = "";
            } else {
                string = StringsKt.take((String)string3, (int)36);
                if (string == null) {
                    string = "";
                }
            }
            return string;
        }

        @JvmStatic
        public final long findTimestampInFilename(@NotNull File file) {
            Long l;
            String fileName = file.getName();
            if (this.isFileV3$bugsnag_android_core_release(file)) {
                fileName = StringsKt.substringAfter$default((String)file.getName(), (char)'_', null, (int)2, null);
            }
            return (l = StringsKt.toLongOrNull((String)StringsKt.substringBefore$default((String)StringsKt.drop((String)fileName, (int)this.findUuidInFilename(file).length()), (char)'_', null, (int)2, null))) == null ? -1L : l;
        }

        @JvmStatic
        @NotNull
        public final String findApiKeyInFilename(@Nullable File file, @NotNull String defaultApiKey) {
            String string;
            if (file == null || !this.isFileV3$bugsnag_android_core_release(file)) {
                return defaultApiKey;
            }
            String it = string = StringsKt.substringBefore$default((String)file.getName(), (char)'_', null, (int)2, null);
            boolean bl = false;
            String string2 = !(((CharSequence)it).length() == 0) ? string : null;
            if (string2 == null) {
                string2 = defaultApiKey;
            }
            return string2;
        }

        public final boolean isFileV3$bugsnag_android_core_release(@NotNull File file) {
            return StringsKt.endsWith$default((String)file.getName(), (String)"_v3.json", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

