/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.net.TrafficStats;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeliveryStatus;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Session;
import com.bugsnag.android.internal.JsonHelper;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\fH\u0016J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0014J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0002J8\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0014H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/bugsnag/android/DefaultDelivery;", "Lcom/bugsnag/android/Delivery;", "connectivity", "Lcom/bugsnag/android/Connectivity;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Lcom/bugsnag/android/Logger;)V", "deliver", "Lcom/bugsnag/android/DeliveryStatus;", "payload", "Lcom/bugsnag/android/EventPayload;", "deliveryParams", "Lcom/bugsnag/android/DeliveryParams;", "Lcom/bugsnag/android/Session;", "urlString", "", "json", "", "integrity", "headers", "", "logRequestInfo", "", "code", "", "conn", "Ljava/net/HttpURLConnection;", "status", "makeRequest", "url", "Ljava/net/URL;", "bugsnag-android-core_release"})
public final class DefaultDelivery
implements Delivery {
    @Nullable
    private final Connectivity connectivity;
    @NotNull
    private final Logger logger;

    public DefaultDelivery(@Nullable Connectivity connectivity, @NotNull Logger logger) {
        this.connectivity = connectivity;
        this.logger = logger;
    }

    @Override
    @NotNull
    public DeliveryStatus deliver(@NotNull Session payload, @NotNull DeliveryParams deliveryParams) {
        DeliveryStatus status = this.deliver(deliveryParams.getEndpoint(), JsonHelper.INSTANCE.serialize(payload), payload.getIntegrityToken(), deliveryParams.getHeaders());
        this.logger.i(Intrinsics.stringPlus((String)"Session API request finished with status ", (Object)((Object)status)));
        return status;
    }

    @Override
    @NotNull
    public DeliveryStatus deliver(@NotNull EventPayload payload, @NotNull DeliveryParams deliveryParams) {
        byte[] json = EventPayload.trimToSize$default(payload, 0, 1, null).toByteArray();
        DeliveryStatus status = this.deliver(deliveryParams.getEndpoint(), json, payload.getIntegrityToken(), deliveryParams.getHeaders());
        this.logger.i(Intrinsics.stringPlus((String)"Error API request finished with status ", (Object)((Object)status)));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DeliveryStatus deliver(@NotNull String urlString, @NotNull byte[] json, @Nullable String integrity, @NotNull Map<String, String> headers) {
        TrafficStats.setThreadStatsTag((int)1);
        if (this.connectivity != null && !this.connectivity.hasNetworkConnection()) {
            return DeliveryStatus.UNDELIVERED;
        }
        HttpURLConnection conn = null;
        try {
            conn = this.makeRequest(new URL(urlString), json, integrity, headers);
            int responseCode = conn.getResponseCode();
            DeliveryStatus status = DeliveryStatus.Companion.forHttpResponseCode(responseCode);
            this.logRequestInfo(responseCode, conn, status);
            DeliveryStatus deliveryStatus = status;
            return deliveryStatus;
        }
        catch (OutOfMemoryError oom) {
            this.logger.w("Encountered OOM delivering payload, falling back to persist on disk", oom);
            DeliveryStatus deliveryStatus = DeliveryStatus.UNDELIVERED;
            return deliveryStatus;
        }
        catch (IOException exception) {
            this.logger.w("IOException encountered in request", exception);
            DeliveryStatus deliveryStatus = DeliveryStatus.UNDELIVERED;
            return deliveryStatus;
        }
        catch (Exception exception) {
            this.logger.w("Unexpected error delivering payload", exception);
            DeliveryStatus deliveryStatus = DeliveryStatus.FAILURE;
            return deliveryStatus;
        }
        finally {
            HttpURLConnection httpURLConnection = conn;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpURLConnection makeRequest(URL url, byte[] json, String integrity, Map<String, String> headers) {
        Object digest;
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setDoOutput(true);
        conn.setFixedLengthStreamingMode(json.length);
        String string = integrity;
        if (string != null) {
            digest = string;
            boolean bl = false;
            conn.addRequestProperty("Bugsnag-Integrity", (String)digest);
        }
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        digest = $this$forEach$iv.entrySet().iterator();
        while (digest.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$key$value = element$iv = (Map.Entry)digest.next();
            boolean bl = false;
            String key = (String)$dstr$key$value.getKey();
            String value = (String)$dstr$key$value.getValue();
            if (value == null) continue;
            conn.addRequestProperty(key, value);
        }
        Closeable closeable = conn.getOutputStream();
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            it.write(json);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logRequestInfo(int code, HttpURLConnection conn, DeliveryStatus status) {
        int n;
        Closeable it2;
        Closeable closeable;
        Object object;
        Closeable closeable2;
        Object object2;
        DefaultDelivery defaultDelivery = this;
        try {
            DefaultDelivery $this$logRequestInfo_u24lambda_u2d3 = defaultDelivery;
            boolean bl = false;
            $this$logRequestInfo_u24lambda_u2d3.logger.i("Request completed with code " + code + ", message: " + conn.getResponseMessage() + ", headers: " + conn.getHeaderFields());
            object2 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable $this$logRequestInfo_u24lambda_u2d3) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$logRequestInfo_u24lambda_u2d3));
        }
        defaultDelivery = this;
        try {
            DefaultDelivery $this$logRequestInfo_u24lambda_u2d5 = defaultDelivery;
            boolean bl = false;
            closeable2 = conn.getInputStream();
            object = Charsets.UTF_8;
            closeable = closeable2;
            closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n2 = 8192;
            closeable2 = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
            object = null;
            try {
                it2 = (BufferedReader)closeable2;
                n = 0;
                $this$logRequestInfo_u24lambda_u2d5.logger.d(Intrinsics.stringPlus((String)"Received request response: ", (Object)TextStreamsKt.readText((Reader)((Reader)it2))));
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                object = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            object2 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable $this$logRequestInfo_u24lambda_u2d5) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$logRequestInfo_u24lambda_u2d5));
        }
        defaultDelivery = this;
        try {
            DefaultDelivery $this$logRequestInfo_u24lambda_u2d7 = defaultDelivery;
            boolean bl = false;
            if (status != DeliveryStatus.DELIVERED) {
                closeable2 = conn.getErrorStream();
                object = Charsets.UTF_8;
                it2 = closeable2;
                it2 = new InputStreamReader((InputStream)it2, (Charset)object);
                n = 8192;
                closeable2 = it2 instanceof BufferedReader ? (BufferedReader)it2 : new BufferedReader((Reader)it2, n);
                object = null;
                try {
                    it2 = (BufferedReader)closeable2;
                    boolean bl2 = false;
                    $this$logRequestInfo_u24lambda_u2d7.logger.w(Intrinsics.stringPlus((String)"Request error details: ", (Object)TextStreamsKt.readText((Reader)((Reader)it2))));
                    closeable = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
            }
            object2 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }
}

