/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.EndpointConfiguration;
import com.bugsnag.android.ManifestConfigLoader;
import com.bugsnag.android.ThreadSendPolicy;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0002J0\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0004H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ!\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0001\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/bugsnag/android/ManifestConfigLoader;", "", "()V", "getPatternSet", "", "Ljava/util/regex/Pattern;", "data", "Landroid/os/Bundle;", "key", "", "default", "getStrArray", "load", "Lcom/bugsnag/android/Configuration;", "ctx", "Landroid/content/Context;", "userSuppliedApiKey", "load$bugsnag_android_core_release", "loadAppConfig", "", "config", "loadDetectionConfig", "loadEndpointsConfig", "Companion", "bugsnag-android-core_release"})
public final class ManifestConfigLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String BUGSNAG_NS = "com.bugsnag.android";
    @NotNull
    private static final String API_KEY = "com.bugsnag.android.API_KEY";
    @NotNull
    public static final String BUILD_UUID = "com.bugsnag.android.BUILD_UUID";
    @NotNull
    private static final String AUTO_TRACK_SESSIONS = "com.bugsnag.android.AUTO_TRACK_SESSIONS";
    @NotNull
    private static final String AUTO_DETECT_ERRORS = "com.bugsnag.android.AUTO_DETECT_ERRORS";
    @NotNull
    private static final String PERSIST_USER = "com.bugsnag.android.PERSIST_USER";
    @NotNull
    private static final String SEND_THREADS = "com.bugsnag.android.SEND_THREADS";
    @NotNull
    private static final String ENDPOINT_NOTIFY = "com.bugsnag.android.ENDPOINT_NOTIFY";
    @NotNull
    private static final String ENDPOINT_SESSIONS = "com.bugsnag.android.ENDPOINT_SESSIONS";
    @NotNull
    private static final String APP_VERSION = "com.bugsnag.android.APP_VERSION";
    @NotNull
    private static final String VERSION_CODE = "com.bugsnag.android.VERSION_CODE";
    @NotNull
    private static final String RELEASE_STAGE = "com.bugsnag.android.RELEASE_STAGE";
    @NotNull
    private static final String ENABLED_RELEASE_STAGES = "com.bugsnag.android.ENABLED_RELEASE_STAGES";
    @NotNull
    private static final String DISCARD_CLASSES = "com.bugsnag.android.DISCARD_CLASSES";
    @NotNull
    private static final String PROJECT_PACKAGES = "com.bugsnag.android.PROJECT_PACKAGES";
    @NotNull
    private static final String REDACTED_KEYS = "com.bugsnag.android.REDACTED_KEYS";
    @NotNull
    private static final String MAX_BREADCRUMBS = "com.bugsnag.android.MAX_BREADCRUMBS";
    @NotNull
    private static final String MAX_PERSISTED_EVENTS = "com.bugsnag.android.MAX_PERSISTED_EVENTS";
    @NotNull
    private static final String MAX_PERSISTED_SESSIONS = "com.bugsnag.android.MAX_PERSISTED_SESSIONS";
    @NotNull
    private static final String MAX_REPORTED_THREADS = "com.bugsnag.android.MAX_REPORTED_THREADS";
    @NotNull
    private static final String THREAD_COLLECTION_TIME_LIMIT_MS = "com.bugsnag.android.THREAD_COLLECTION_TIME_LIMIT_MS";
    @NotNull
    private static final String LAUNCH_CRASH_THRESHOLD_MS = "com.bugsnag.android.LAUNCH_CRASH_THRESHOLD_MS";
    @NotNull
    private static final String LAUNCH_DURATION_MILLIS = "com.bugsnag.android.LAUNCH_DURATION_MILLIS";
    @NotNull
    private static final String SEND_LAUNCH_CRASHES_SYNCHRONOUSLY = "com.bugsnag.android.SEND_LAUNCH_CRASHES_SYNCHRONOUSLY";
    @NotNull
    private static final String APP_TYPE = "com.bugsnag.android.APP_TYPE";
    @NotNull
    private static final String ATTEMPT_DELIVERY_ON_CRASH = "com.bugsnag.android.ATTEMPT_DELIVERY_ON_CRASH";

    @NotNull
    public final Configuration load(@NotNull Context ctx, @Nullable String userSuppliedApiKey) {
        try {
            PackageManager packageManager = ctx.getPackageManager();
            String packageName = ctx.getPackageName();
            ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 128);
            Bundle data = ai.metaData;
            return this.load$bugsnag_android_core_release(data, userSuppliedApiKey);
        }
        catch (Exception exc) {
            throw new IllegalStateException("Bugsnag is unable to read config from manifest.", exc);
        }
    }

    @VisibleForTesting
    @NotNull
    public final Configuration load$bugsnag_android_core_release(@Nullable Bundle data, @Nullable String userSuppliedApiKey) {
        String string;
        String string2 = userSuppliedApiKey;
        if (string2 == null) {
            String string3;
            Bundle bundle = data;
            String string4 = string3 = bundle == null ? null : bundle.getString(API_KEY);
            if (string3 == null) {
                throw new IllegalArgumentException("No Bugsnag API key set");
            }
            string = string3;
        } else {
            string = string2;
        }
        String apiKey = string;
        Configuration config = new Configuration(apiKey);
        if (data != null) {
            this.loadDetectionConfig(config, data);
            this.loadEndpointsConfig(config, data);
            this.loadAppConfig(config, data);
            boolean bl = false;
            boolean bl2 = false;
            Configuration $this$load_u24lambda_u2d0 = config;
            boolean bl3 = false;
            $this$load_u24lambda_u2d0.setMaxBreadcrumbs(data.getInt(MAX_BREADCRUMBS, $this$load_u24lambda_u2d0.getMaxBreadcrumbs()));
            $this$load_u24lambda_u2d0.setMaxPersistedEvents(data.getInt(MAX_PERSISTED_EVENTS, $this$load_u24lambda_u2d0.getMaxPersistedEvents()));
            $this$load_u24lambda_u2d0.setMaxPersistedSessions(data.getInt(MAX_PERSISTED_SESSIONS, $this$load_u24lambda_u2d0.getMaxPersistedSessions()));
            $this$load_u24lambda_u2d0.setMaxReportedThreads(data.getInt(MAX_REPORTED_THREADS, $this$load_u24lambda_u2d0.getMaxReportedThreads()));
            $this$load_u24lambda_u2d0.setThreadCollectionTimeLimitMillis(data.getLong(THREAD_COLLECTION_TIME_LIMIT_MS, $this$load_u24lambda_u2d0.getThreadCollectionTimeLimitMillis()));
            $this$load_u24lambda_u2d0.setLaunchDurationMillis(data.getInt(LAUNCH_DURATION_MILLIS, (int)$this$load_u24lambda_u2d0.getLaunchDurationMillis()));
            $this$load_u24lambda_u2d0.setSendLaunchCrashesSynchronously(data.getBoolean(SEND_LAUNCH_CRASHES_SYNCHRONOUSLY, $this$load_u24lambda_u2d0.getSendLaunchCrashesSynchronously()));
            $this$load_u24lambda_u2d0.setAttemptDeliveryOnCrash(data.getBoolean(ATTEMPT_DELIVERY_ON_CRASH, $this$load_u24lambda_u2d0.isAttemptDeliveryOnCrash()));
        }
        return config;
    }

    private final void loadDetectionConfig(Configuration config, Bundle data) {
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$loadDetectionConfig_u24lambda_u2d1 = config;
        boolean bl3 = false;
        $this$loadDetectionConfig_u24lambda_u2d1.setAutoTrackSessions(data.getBoolean(AUTO_TRACK_SESSIONS, $this$loadDetectionConfig_u24lambda_u2d1.getAutoTrackSessions()));
        $this$loadDetectionConfig_u24lambda_u2d1.setAutoDetectErrors(data.getBoolean(AUTO_DETECT_ERRORS, $this$loadDetectionConfig_u24lambda_u2d1.getAutoDetectErrors()));
        $this$loadDetectionConfig_u24lambda_u2d1.setPersistUser(data.getBoolean(PERSIST_USER, $this$loadDetectionConfig_u24lambda_u2d1.getPersistUser()));
        String str = data.getString(SEND_THREADS);
        if (str != null) {
            $this$loadDetectionConfig_u24lambda_u2d1.setSendThreads(ThreadSendPolicy.Companion.fromString(str));
        }
    }

    private final void loadEndpointsConfig(Configuration config, Bundle data) {
        if (data.containsKey(ENDPOINT_NOTIFY)) {
            String endpoint = data.getString(ENDPOINT_NOTIFY, config.getEndpoints().getNotify());
            String sessionEndpoint = data.getString(ENDPOINT_SESSIONS, config.getEndpoints().getSessions());
            config.setEndpoints(new EndpointConfiguration(endpoint, sessionEndpoint));
        }
    }

    private final void loadAppConfig(Configuration config, Bundle data) {
        Set<Object> set;
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$loadAppConfig_u24lambda_u2d2 = config;
        boolean bl3 = false;
        $this$loadAppConfig_u24lambda_u2d2.setReleaseStage(data.getString(RELEASE_STAGE, config.getReleaseStage()));
        $this$loadAppConfig_u24lambda_u2d2.setAppVersion(data.getString(APP_VERSION, config.getAppVersion()));
        $this$loadAppConfig_u24lambda_u2d2.setAppType(data.getString(APP_TYPE, config.getAppType()));
        if (data.containsKey(VERSION_CODE)) {
            $this$loadAppConfig_u24lambda_u2d2.setVersionCode(data.getInt(VERSION_CODE));
        }
        if (data.containsKey(ENABLED_RELEASE_STAGES)) {
            $this$loadAppConfig_u24lambda_u2d2.setEnabledReleaseStages(this.getStrArray(data, ENABLED_RELEASE_STAGES, $this$loadAppConfig_u24lambda_u2d2.getEnabledReleaseStages()));
        }
        $this$loadAppConfig_u24lambda_u2d2.setDiscardClasses((set = this.getPatternSet(data, DISCARD_CLASSES, $this$loadAppConfig_u24lambda_u2d2.getDiscardClasses())) == null ? SetsKt.emptySet() : set);
        set = this.getStrArray(data, PROJECT_PACKAGES, SetsKt.emptySet());
        $this$loadAppConfig_u24lambda_u2d2.setProjectPackages(set == null ? SetsKt.emptySet() : set);
        set = this.getPatternSet(data, REDACTED_KEYS, $this$loadAppConfig_u24lambda_u2d2.getRedactedKeys());
        $this$loadAppConfig_u24lambda_u2d2.setRedactedKeys(set == null ? SetsKt.emptySet() : set);
    }

    private final Set<String> getStrArray(Bundle data, String key, Set<String> set) {
        List list;
        String delimitedStr = data.getString(key);
        String string = delimitedStr;
        if (string == null) {
            list = null;
        } else {
            String[] stringArray = new String[]{","};
            list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        List ary = list;
        return ary == null ? set : CollectionsKt.toSet((Iterable)ary);
    }

    private final Set<Pattern> getPatternSet(Bundle data, String key, Set<Pattern> set) {
        Object object = data.getString(key);
        if (object == null) {
            return set;
        }
        String delimitedStr = object;
        object = new char[1];
        object[0] = 44;
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)delimitedStr, (char[])object, (boolean)false, (int)0, (int)6, null), (Function1)getPatternSet.1.INSTANCE));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/bugsnag/android/ManifestConfigLoader$Companion;", "", "()V", "API_KEY", "", "APP_TYPE", "APP_VERSION", "ATTEMPT_DELIVERY_ON_CRASH", "AUTO_DETECT_ERRORS", "AUTO_TRACK_SESSIONS", "BUGSNAG_NS", "BUILD_UUID", "DISCARD_CLASSES", "ENABLED_RELEASE_STAGES", "ENDPOINT_NOTIFY", "ENDPOINT_SESSIONS", "LAUNCH_CRASH_THRESHOLD_MS", "LAUNCH_DURATION_MILLIS", "MAX_BREADCRUMBS", "MAX_PERSISTED_EVENTS", "MAX_PERSISTED_SESSIONS", "MAX_REPORTED_THREADS", "PERSIST_USER", "PROJECT_PACKAGES", "REDACTED_KEYS", "RELEASE_STAGE", "SEND_LAUNCH_CRASHES_SYNCHRONOUSLY", "SEND_THREADS", "THREAD_COLLECTION_TIME_LIMIT_MS", "VERSION_CODE", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

