/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.BaseObservable;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.Logger;
import com.bugsnag.android.StateEvent;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/bugsnag/android/LaunchCrashTracker;", "Lcom/bugsnag/android/BaseObservable;", "config", "Lcom/bugsnag/android/ImmutableConfig;", "executor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "(Lcom/bugsnag/android/ImmutableConfig;Ljava/util/concurrent/ScheduledThreadPoolExecutor;)V", "launching", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lcom/bugsnag/android/Logger;", "isLaunching", "", "markLaunchCompleted", "", "bugsnag-android-core_release"})
public final class LaunchCrashTracker
extends BaseObservable {
    private final AtomicBoolean launching;
    private final Logger logger;
    private final ScheduledThreadPoolExecutor executor;

    public final void markLaunchCompleted() {
        this.executor.shutdown();
        this.launching.set(false);
        this.notifyObservers(new StateEvent.UpdateIsLaunching(false));
        this.logger.d("App launch period marked as complete");
    }

    public final boolean isLaunching() {
        return this.launching.get();
    }

    @JvmOverloads
    public LaunchCrashTracker(@NotNull ImmutableConfig config, @NotNull ScheduledThreadPoolExecutor executor) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        this.executor = executor;
        this.launching = new AtomicBoolean(true);
        this.logger = config.getLogger();
        long delay = config.getLaunchDurationMillis();
        if (delay > 0L) {
            this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            try {
                this.executor.schedule(new Runnable(){

                    @Override
                    public final void run() {
                        this.markLaunchCompleted();
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException exc) {
                this.logger.w("Failed to schedule timer for LaunchCrashTracker", exc);
            }
        }
    }

    public /* synthetic */ LaunchCrashTracker(ImmutableConfig immutableConfig, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        }
        this(immutableConfig, scheduledThreadPoolExecutor);
    }

    @JvmOverloads
    public LaunchCrashTracker(@NotNull ImmutableConfig config) {
        this(config, null, 2, null);
    }
}

