/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.BreadcrumbInternal;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class Breadcrumb
implements JsonStream.Streamable {
    private final BreadcrumbInternal impl;
    private final Logger logger;

    Breadcrumb(@NonNull String message, @NonNull Logger logger) {
        this.impl = new BreadcrumbInternal(message);
        this.logger = logger;
    }

    Breadcrumb(@NonNull String message, @NonNull BreadcrumbType type, @Nullable Map<String, Object> metadata, @NonNull Date timestamp, @NonNull Logger logger) {
        this.impl = new BreadcrumbInternal(message, type, metadata, timestamp);
        this.logger = logger;
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to breadcrumb." + property + ", ignoring");
    }

    public void setMessage(@NonNull String message) {
        if (message != null) {
            this.impl.setMessage(message);
        } else {
            this.logNull("message");
        }
    }

    @NonNull
    public String getMessage() {
        return this.impl.getMessage();
    }

    public void setType(@NonNull BreadcrumbType type) {
        if (type != null) {
            this.impl.setType(type);
        } else {
            this.logNull("type");
        }
    }

    @NonNull
    public BreadcrumbType getType() {
        return this.impl.getType();
    }

    public void setMetadata(@Nullable Map<String, Object> metadata) {
        this.impl.setMetadata(metadata);
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.impl.getMetadata();
    }

    @NonNull
    public Date getTimestamp() {
        return this.impl.getTimestamp();
    }

    @NonNull
    String getStringTimestamp() {
        return DateUtils.toIso8601(this.impl.getTimestamp());
    }

    @Override
    public void toStream(@NonNull JsonStream stream) throws IOException {
        this.impl.toStream(stream);
    }
}

