/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.BaseObservable;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.Logger;
import com.bugsnag.android.StateEvent;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/bugsnag/android/LaunchCrashTracker;", "Lcom/bugsnag/android/BaseObservable;", "config", "Lcom/bugsnag/android/ImmutableConfig;", "(Lcom/bugsnag/android/ImmutableConfig;)V", "executor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "launching", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lcom/bugsnag/android/Logger;", "isLaunching", "", "markLaunchCompleted", "", "bugsnag-android-core_release"})
public final class LaunchCrashTracker
extends BaseObservable {
    private final AtomicBoolean launching;
    private final ScheduledThreadPoolExecutor executor;
    private final Logger logger;

    public final void markLaunchCompleted() {
        this.executor.shutdown();
        this.launching.set(false);
        this.notifyObservers(new StateEvent.UpdateIsLaunching(false));
        this.logger.d("App launch period marked as complete");
    }

    public final boolean isLaunching() {
        return this.launching.get();
    }

    public LaunchCrashTracker(@NotNull ImmutableConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.launching = new AtomicBoolean(true);
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.logger = config.getLogger();
        long delay = config.getLaunchDurationMillis();
        if (delay > 0L) {
            this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            try {
                this.executor.schedule(new Runnable(){

                    @Override
                    public final void run() {
                        this.markLaunchCompleted();
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException exc) {
                this.logger.w("Failed to schedule timer for LaunchCrashTracker", exc);
            }
        }
    }
}

