/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import com.bugsnag.android.App;
import com.bugsnag.android.AppWithState;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SessionTracker;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0011\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0000\u00a2\u0006\u0004\b \u0010!J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u0004\u0018\u00010\u0012J\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010(J\n\u0010)\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010*\u001a\u00020\u001fH\u0002J\u000f\u0010+\u001a\u0004\u0018\u00010,H\u0002\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/bugsnag/android/AppDataCollector;", "", "appContext", "Landroid/content/Context;", "packageManager", "Landroid/content/pm/PackageManager;", "config", "Lcom/bugsnag/android/ImmutableConfig;", "sessionTracker", "Lcom/bugsnag/android/SessionTracker;", "activityManager", "Landroid/app/ActivityManager;", "logger", "Lcom/bugsnag/android/Logger;", "(Landroid/content/Context;Landroid/content/pm/PackageManager;Lcom/bugsnag/android/ImmutableConfig;Lcom/bugsnag/android/SessionTracker;Landroid/app/ActivityManager;Lcom/bugsnag/android/Logger;)V", "appInfo", "Landroid/content/pm/ApplicationInfo;", "appName", "", "binaryArch", "codeBundleId", "getCodeBundleId", "()Ljava/lang/String;", "setCodeBundleId", "(Ljava/lang/String;)V", "packageInfo", "Landroid/content/pm/PackageInfo;", "packageName", "releaseStage", "versionName", "calculateDurationInForeground", "", "calculateDurationInForeground$bugsnag_android_core_release", "()Ljava/lang/Long;", "generateApp", "Lcom/bugsnag/android/App;", "generateAppWithState", "Lcom/bugsnag/android/AppWithState;", "getActiveScreenClass", "getAppDataMetadata", "", "getAppName", "getMemoryUsage", "isLowMemory", "", "()Ljava/lang/Boolean;", "setBinaryArch", "", "Companion", "bugsnag-android-core_release"})
public final class AppDataCollector {
    @Nullable
    private String codeBundleId;
    private final String packageName;
    private PackageInfo packageInfo;
    private ApplicationInfo appInfo;
    private String binaryArch;
    private final String appName;
    private final String releaseStage;
    private final String versionName;
    private final PackageManager packageManager;
    private final ImmutableConfig config;
    private final SessionTracker sessionTracker;
    private final ActivityManager activityManager;
    private final Logger logger;
    private static final long startTimeMs;
    public static final Companion Companion;

    @Nullable
    public final String getCodeBundleId() {
        return this.codeBundleId;
    }

    public final void setCodeBundleId(@Nullable String string) {
        this.codeBundleId = string;
    }

    @NotNull
    public final App generateApp() {
        return new App(this.config, this.binaryArch, this.packageName, this.releaseStage, this.versionName, this.codeBundleId);
    }

    @NotNull
    public final AppWithState generateAppWithState() {
        return new AppWithState(this.config, this.binaryArch, this.packageName, this.releaseStage, this.versionName, this.codeBundleId, Companion.getDurationMs(), this.calculateDurationInForeground$bugsnag_android_core_release(), this.sessionTracker.isInForeground());
    }

    @NotNull
    public final Map<String, Object> getAppDataMetadata() {
        HashMap map = new HashMap();
        ((Map)map).put("name", this.appName);
        ((Map)map).put("activeScreen", this.getActiveScreenClass());
        ((Map)map).put("memoryUsage", this.getMemoryUsage());
        ((Map)map).put("lowMemory", this.isLowMemory());
        return map;
    }

    @Nullable
    public final String getActiveScreenClass() {
        return this.sessionTracker.getContextActivity();
    }

    private final long getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private final Boolean isLowMemory() {
        try {
            if (this.activityManager != null) {
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                this.activityManager.getMemoryInfo(memInfo);
                return memInfo.lowMemory;
            }
        }
        catch (Exception exception) {
            this.logger.w("Could not check lowMemory status");
        }
        return null;
    }

    public final void setBinaryArch(@NotNull String binaryArch) {
        Intrinsics.checkParameterIsNotNull((Object)binaryArch, (String)"binaryArch");
        this.binaryArch = binaryArch;
    }

    @Nullable
    public final Long calculateDurationInForeground$bugsnag_android_core_release() {
        long nowMs = System.currentTimeMillis();
        return this.sessionTracker.getDurationInForegroundMs(nowMs);
    }

    private final String getAppName() {
        String string;
        boolean hasInfo = this.packageManager != null && this.appInfo != null;
        if (hasInfo) {
            PackageManager packageManager = this.packageManager;
            string = String.valueOf(packageManager != null ? packageManager.getApplicationLabel(this.appInfo) : null);
        } else {
            string = null;
        }
        return string;
    }

    public AppDataCollector(@NotNull Context appContext, @Nullable PackageManager packageManager, @NotNull ImmutableConfig config, @NotNull SessionTracker sessionTracker, @Nullable ActivityManager activityManager, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)sessionTracker, (String)"sessionTracker");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.packageManager = packageManager;
        this.config = config;
        this.sessionTracker = sessionTracker;
        this.activityManager = activityManager;
        this.logger = logger;
        String string = appContext.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"appContext.packageName");
        this.packageName = string;
        PackageManager packageManager2 = this.packageManager;
        this.packageInfo = packageManager2 != null ? packageManager2.getPackageInfo(this.packageName, 0) : null;
        PackageManager packageManager3 = this.packageManager;
        this.appInfo = packageManager3 != null ? packageManager3.getApplicationInfo(this.packageName, 0) : null;
        this.appName = this.getAppName();
        this.releaseStage = this.config.getReleaseStage();
        String string2 = this.config.getAppVersion();
        if (string2 == null) {
            PackageInfo packageInfo = this.packageInfo;
            string2 = packageInfo != null ? packageInfo.versionName : null;
        }
        this.versionName = string2;
    }

    static {
        Companion = new Companion(null);
        startTimeMs = SystemClock.elapsedRealtime();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/bugsnag/android/AppDataCollector$Companion;", "", "()V", "startTimeMs", "", "getStartTimeMs$bugsnag_android_core_release", "()J", "getDurationMs", "bugsnag-android-core_release"})
    public static final class Companion {
        public final long getStartTimeMs$bugsnag_android_core_release() {
            return startTimeMs;
        }

        public final long getDurationMs() {
            return SystemClock.elapsedRealtime() - this.getStartTimeMs$bugsnag_android_core_release();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

