/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import com.bugsnag.android.NdkPluginCaller;
import com.bugsnag.android.internal.InternalMetrics;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u001c\u0010\u0019\u001a\u00020\u00112\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0003H\u0016J\u001c\u0010\u001b\u001a\u00020\u00112\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/bugsnag/android/internal/InternalMetricsImpl;", "Lcom/bugsnag/android/internal/InternalMetrics;", "source", "", "", "", "(Ljava/util/Map;)V", "breadcrumbBytesRemovedCount", "", "breadcrumbsRemovedCount", "callbackCounts", "", "configDifferences", "metadataCharsTruncatedCount", "metadataStringsTrimmedCount", "allCallbacks", "modifyCallback", "", "callback", "delta", "notifyAddCallback", "notifyRemoveCallback", "setBreadcrumbTrimMetrics", "breadcrumbsRemoved", "bytesRemoved", "setCallbackCounts", "newCallbackCounts", "setConfigDifferences", "differences", "setMetadataTrimMetrics", "stringsTrimmed", "charsRemoved", "toJsonableMap", "bugsnag-android-core_release"})
public final class InternalMetricsImpl
implements InternalMetrics {
    private final Map<String, Object> configDifferences;
    private final Map<String, Integer> callbackCounts;
    private int metadataStringsTrimmedCount;
    private int metadataCharsTruncatedCount;
    private int breadcrumbsRemovedCount;
    private int breadcrumbBytesRemovedCount;

    @Override
    @NotNull
    public Map<String, Object> toJsonableMap() {
        Map<String, Object> callbacks = this.allCallbacks();
        Map system = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])new Pair[]{this.metadataStringsTrimmedCount > 0 ? TuplesKt.to((Object)"stringsTruncated", (Object)this.metadataStringsTrimmedCount) : null, this.metadataCharsTruncatedCount > 0 ? TuplesKt.to((Object)"stringCharsTruncated", (Object)this.metadataCharsTruncatedCount) : null, this.breadcrumbsRemovedCount > 0 ? TuplesKt.to((Object)"breadcrumbsRemoved", (Object)this.breadcrumbsRemovedCount) : null, this.breadcrumbBytesRemovedCount > 0 ? TuplesKt.to((Object)"breadcrumbBytesRemoved", (Object)this.breadcrumbBytesRemovedCount) : null}));
        Object[] objectArray = new Pair[3];
        Map map = this.configDifferences;
        boolean bl = false;
        objectArray[0] = !map.isEmpty() ? TuplesKt.to((Object)"config", this.configDifferences) : null;
        map = callbacks;
        bl = false;
        objectArray[1] = !map.isEmpty() ? TuplesKt.to((Object)"callbacks", callbacks) : null;
        map = system;
        bl = false;
        objectArray[2] = !map.isEmpty() ? TuplesKt.to((Object)"system", (Object)system) : null;
        return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    @Override
    public void setConfigDifferences(@NotNull Map<String, ? extends Object> differences) {
        Intrinsics.checkParameterIsNotNull(differences, (String)"differences");
        this.configDifferences.clear();
        this.configDifferences.putAll(differences);
        NdkPluginCaller.INSTANCE.setStaticData(MapsKt.mapOf((Pair)TuplesKt.to((Object)"usage", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"config", this.configDifferences)))));
    }

    @Override
    public void setCallbackCounts(@NotNull Map<String, Integer> newCallbackCounts) {
        Intrinsics.checkParameterIsNotNull(newCallbackCounts, (String)"newCallbackCounts");
        this.callbackCounts.clear();
        this.callbackCounts.putAll(newCallbackCounts);
        NdkPluginCaller.INSTANCE.initCallbackCounts(newCallbackCounts);
    }

    @Override
    public void notifyAddCallback(@NotNull String callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.modifyCallback(callback, 1);
        NdkPluginCaller.INSTANCE.notifyAddCallback(callback);
    }

    @Override
    public void notifyRemoveCallback(@NotNull String callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.modifyCallback(callback, -1);
        NdkPluginCaller.INSTANCE.notifyRemoveCallback(callback);
    }

    private final void modifyCallback(String callback, int delta) {
        Integer n = this.callbackCounts.get(callback);
        int currentValue = n != null ? n : 0;
        this.callbackCounts.put(callback, RangesKt.coerceAtLeast((int)(currentValue += delta), (int)0));
    }

    private final Map<String, Object> allCallbacks() {
        Map<String, Boolean> usage;
        Integer ndkOnError;
        boolean bl = false;
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.putAll(this.callbackCounts);
        Map<String, Integer> counts = NdkPluginCaller.INSTANCE.getCurrentCallbackSetCounts();
        if (counts != null && (ndkOnError = counts.get("ndkOnError")) != null) {
            ((Map)result).put("ndkOnError", ndkOnError);
        }
        if ((usage = NdkPluginCaller.INSTANCE.getCurrentNativeApiCallUsage()) != null) {
            result.putAll(usage);
        }
        return result;
    }

    @Override
    public void setMetadataTrimMetrics(int stringsTrimmed, int charsRemoved) {
        this.metadataStringsTrimmedCount = stringsTrimmed;
        this.metadataCharsTruncatedCount = charsRemoved;
    }

    @Override
    public void setBreadcrumbTrimMetrics(int breadcrumbsRemoved, int bytesRemoved) {
        this.breadcrumbsRemovedCount = breadcrumbsRemoved;
        this.breadcrumbBytesRemovedCount = bytesRemoved;
    }

    public InternalMetricsImpl(@Nullable Map<String, ? extends Object> source) {
        if (source != null) {
            Map map;
            boolean bl;
            Map map2 = TypeIntrinsics.asMutableMap((Object)source.get("config"));
            if (map2 == null) {
                bl = false;
                map2 = this.configDifferences = (Map)new HashMap();
            }
            if ((map = TypeIntrinsics.asMutableMap((Object)source.get("callbacks"))) == null) {
                bl = false;
                map = new HashMap();
            }
            this.callbackCounts = map;
            Map system = TypeIntrinsics.asMutableMap((Object)source.get("system"));
            if (system != null) {
                Number number = (Number)system.get("stringsTruncated");
                this.metadataStringsTrimmedCount = number != null ? number.intValue() : 0;
                Number number2 = (Number)system.get("stringCharsTruncated");
                this.metadataCharsTruncatedCount = number2 != null ? number2.intValue() : 0;
                Number number3 = (Number)system.get("breadcrumbsRemovedCount");
                this.breadcrumbsRemovedCount = number3 != null ? number3.intValue() : 0;
                Number number4 = (Number)system.get("breadcrumbBytesRemoved");
                this.breadcrumbBytesRemovedCount = number4 != null ? number4.intValue() : 0;
            }
        } else {
            boolean bl = false;
            this.configDifferences = new HashMap();
            bl = false;
            this.callbackCounts = new HashMap();
        }
    }

    public /* synthetic */ InternalMetricsImpl(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = null;
        }
        this(map);
    }

    public InternalMetricsImpl() {
        this(null, 1, null);
    }
}

