/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import com.bugsnag.android.JsonStream;
import com.bugsnag.android.internal.FallbackWriter;
import com.bugsnag.android.repackaged.dslplatform.json.DslJson;
import com.bugsnag.android.repackaged.dslplatform.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FileSystemException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000b\u001a\u0012\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\u0006\b\u0001\u0012\u00020\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0001J\u0016\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u001cR4\u0010\u0003\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001 \u0007*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rh\u0010\b\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001 \u0007*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00050\u0005 \u0007**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001 \u0007*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00050\u0005\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u001d"}, d2={"Lcom/bugsnag/android/internal/JsonHelper;", "", "()V", "dslJson", "Lcom/bugsnag/android/repackaged/dslplatform/json/DslJson;", "", "", "kotlin.jvm.PlatformType", "settings", "Lcom/bugsnag/android/repackaged/dslplatform/json/DslJson$Settings;", "getSettings$annotations", "deserialize", "file", "Ljava/io/File;", "stream", "Ljava/io/InputStream;", "bytes", "", "jsonToLong", "", "value", "(Ljava/lang/Object;)Ljava/lang/Long;", "serialize", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "", "Ljava/io/OutputStream;", "ulongToHex", "(Ljava/lang/Long;)Ljava/lang/String;", "bugsnag-android-core_release"})
public final class JsonHelper {
    private static final DslJson.Settings<Map<String, Object>> settings;
    private static final DslJson<Map<String, Object>> dslJson;
    @NotNull
    public static final JsonHelper INSTANCE;

    private static /* synthetic */ void getSettings$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(@NotNull JsonStream.Streamable streamable) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)streamable, (String)"streamable");
        Closeable closeable = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new JsonStream(new PrintWriter(baos));
            JsonStream.Streamable streamable2 = streamable;
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                JsonStream p1 = (JsonStream)closeable2;
                boolean bl6 = false;
                streamable2.toStream(p1);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteArrayOutputStream().\u2026s.toByteArray()\n        }");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] serialize(@NotNull Object value) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Closeable closeable = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl3 = false;
            INSTANCE.serialize(value, baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ByteArrayOutputStream().\u2026s.toByteArray()\n        }");
        return byArray;
    }

    public final void serialize(@NotNull Object value, @NotNull OutputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        dslJson.serialize(value, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(@NotNull Object value, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw (Throwable)new FileSystemException(file, null, "Could not create parent dirs of file");
        }
        try {
            Closeable closeable = new FileOutputStream(file);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream stream = (FileOutputStream)closeable;
                boolean bl3 = false;
                dslJson.serialize(value, stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ex) {
            throw (Throwable)new IOException("Could not serialize JSON document to " + file, ex);
        }
    }

    @NotNull
    public final Map<String, Object> deserialize(@NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        Map document = dslJson.deserialize(Map.class, bytes, bytes.length);
        boolean bl = false;
        boolean bl2 = false;
        if (document == null) {
            boolean bl3 = false;
            String string = "JSON document is invalid";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return TypeIntrinsics.asMutableMap((Object)document);
    }

    @NotNull
    public final Map<? super String, ? extends Object> deserialize(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        Map document = dslJson.deserialize(Map.class, stream);
        boolean bl = false;
        boolean bl2 = false;
        if (document == null) {
            boolean bl3 = false;
            String string = "JSON document is invalid";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return TypeIntrinsics.asMutableMap((Object)document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<? super String, ? extends Object> deserialize(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            Closeable closeable = new FileInputStream(file);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileInputStream stream = (FileInputStream)closeable;
                boolean bl3 = false;
                Map<? super String, ? extends Object> map = INSTANCE.deserialize(stream);
                return map;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (FileNotFoundException ex) {
            throw (Throwable)ex;
        }
        catch (IOException ex) {
            throw (Throwable)new IOException("Could not deserialize from " + file, ex);
        }
    }

    @Nullable
    public final String ulongToHex(@Nullable Long value) {
        String string;
        if (value == null) {
            string = null;
        } else if (value >= 0L) {
            String string2 = "0x%x";
            Object[] objectArray = new Object[]{value};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        } else {
            String string4 = "0x%x%02x";
            Object[] objectArray = new Object[]{value >>> 8, value & 0xFFL};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
            return string5;
        }
        return string;
    }

    @Nullable
    public final Long jsonToLong(@Nullable Object value) {
        Long l;
        Object object = value;
        if (object == null) {
            l = null;
        } else if (object instanceof Number) {
            l = ((Number)value).longValue();
        } else if (object instanceof String) {
            if (((String)value).length() == 0) {
                l = null;
            } else {
                Long l2;
                try {
                    l2 = Long.decode((String)value);
                }
                catch (NumberFormatException e) {
                    long l3;
                    if (StringsKt.startsWith$default((String)((String)value), (String)"0x", (boolean)false, (int)2, null)) {
                        if (((String)value).length() != 18) {
                            throw (Throwable)e;
                        }
                        int headLength = ((String)value).length() - 2;
                        String string = (String)value;
                        int n = 0;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n, headLength);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        long l4 = Long.decode(string3) << 8;
                        string = (String)value;
                        n = ((String)value).length();
                        bl = false;
                        String string4 = string;
                        if (string4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.substring(headLength, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        string = string5;
                        n = 16;
                        bl = false;
                        l3 = l4 | Long.parseLong(string, CharsKt.checkRadix((int)n));
                    } else {
                        if (((String)value).length() < 19) {
                            throw (Throwable)e;
                        }
                        int headLength = ((String)value).length() - 3;
                        String string = (String)value;
                        int n = 0;
                        boolean bl = false;
                        String string6 = string;
                        if (string6 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n, headLength);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        long l5 = Long.decode(string7) * (long)1000;
                        string = (String)value;
                        n = ((String)value).length();
                        bl = false;
                        String string8 = string;
                        if (string8 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string9 = string8.substring(headLength, n);
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        Long l6 = Long.decode(string9);
                        Intrinsics.checkExpressionValueIsNotNull((Object)l6, (String)"java.lang.Long.decode(va\u2026eadLength, value.length))");
                        l3 = l5 + l6;
                    }
                    l2 = l3;
                }
                l = l2;
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Cannot convert " + value + " to long");
        }
        return l;
    }

    private JsonHelper() {
    }

    static {
        JsonHelper jsonHelper;
        INSTANCE = jsonHelper = new JsonHelper();
        settings = new DslJson.Settings().fallbackTo(new FallbackWriter());
        dslJson = new DslJson<Map<String, Object>>(settings);
        dslJson.registerWriter(Date.class, (JsonWriter.WriteObject)1.INSTANCE);
    }
}

