/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Client;
import com.bugsnag.android.ErrorTypes;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Plugin;
import com.bugsnag.android.internal.ImmutableConfig;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0015J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0015R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/bugsnag/android/PluginClient;", "", "userPlugins", "", "Lcom/bugsnag/android/Plugin;", "immutableConfig", "Lcom/bugsnag/android/internal/ImmutableConfig;", "logger", "Lcom/bugsnag/android/Logger;", "(Ljava/util/Set;Lcom/bugsnag/android/internal/ImmutableConfig;Lcom/bugsnag/android/Logger;)V", "anrPlugin", "ndkPlugin", "plugins", "rnPlugin", "findPlugin", "clz", "Ljava/lang/Class;", "getNdkPlugin", "instantiatePlugin", "", "isWarningEnabled", "", "loadPluginInternal", "", "plugin", "client", "Lcom/bugsnag/android/Client;", "loadPlugins", "setAutoDetectAnrs", "autoDetectAnrs", "setAutoNotify", "autoNotify", "Companion", "bugsnag-android-core_release"})
public final class PluginClient {
    private final Set<Plugin> plugins;
    private final Plugin ndkPlugin;
    private final Plugin anrPlugin;
    private final Plugin rnPlugin;
    private final ImmutableConfig immutableConfig;
    private final Logger logger;
    private static final String NDK_PLUGIN = "com.bugsnag.android.NdkPlugin";
    private static final String ANR_PLUGIN = "com.bugsnag.android.AnrPlugin";
    private static final String RN_PLUGIN = "com.bugsnag.android.BugsnagReactNativePlugin";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final Plugin instantiatePlugin(String clz, boolean isWarningEnabled) {
        Plugin plugin;
        try {
            Class<?> pluginClz = Class.forName(clz);
            Object obj = pluginClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.bugsnag.android.Plugin");
            }
            plugin = (Plugin)obj;
        }
        catch (ClassNotFoundException exc) {
            if (isWarningEnabled) {
                this.logger.d("Plugin '" + clz + "' is not on the classpath - functionality will not be enabled.");
            }
            plugin = null;
        }
        catch (Throwable exc) {
            this.logger.e("Failed to load plugin '" + clz + '\'', exc);
            plugin = null;
        }
        return plugin;
    }

    @Nullable
    public final Plugin getNdkPlugin() {
        return this.ndkPlugin;
    }

    public final void loadPlugins(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Plugin plugin = (Plugin)element$iv;
            boolean bl = false;
            try {
                this.loadPluginInternal(plugin, client);
            }
            catch (Throwable exc) {
                this.logger.e("Failed to load plugin " + plugin + ", continuing with initialisation.", exc);
            }
        }
    }

    public final void setAutoNotify(@NotNull Client client, boolean autoNotify) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                this.setAutoDetectAnrs(client, autoNotify);
                if (!autoNotify) break block0;
                Plugin plugin = this.ndkPlugin;
                if (plugin == null) break block1;
                plugin.load(client);
                break block1;
            }
            Plugin plugin = this.ndkPlugin;
            if (plugin == null) break block1;
            plugin.unload();
        }
    }

    public final void setAutoDetectAnrs(@NotNull Client client, boolean autoDetectAnrs) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
                if (!autoDetectAnrs) break block0;
                Plugin plugin = this.anrPlugin;
                if (plugin == null) break block1;
                plugin.load(client);
                break block1;
            }
            Plugin plugin = this.anrPlugin;
            if (plugin == null) break block1;
            plugin.unload();
        }
    }

    @Nullable
    public final Plugin findPlugin(@NotNull Class<?> clz) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(clz, (String)"clz");
            Iterable iterable = this.plugins;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Plugin it = (Plugin)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getClass(), clz)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void loadPluginInternal(Plugin plugin, Client client) {
        String name = plugin.getClass().getName();
        ErrorTypes errorTypes = this.immutableConfig.getEnabledErrorTypes();
        if (Intrinsics.areEqual((Object)name, (Object)NDK_PLUGIN)) {
            if (errorTypes.getNdkCrashes()) {
                plugin.load(client);
            }
        } else if (Intrinsics.areEqual((Object)name, (Object)ANR_PLUGIN)) {
            if (errorTypes.getAnrs()) {
                plugin.load(client);
            }
        } else {
            plugin.load(client);
        }
    }

    public PluginClient(@NotNull Set<? extends Plugin> userPlugins, @NotNull ImmutableConfig immutableConfig, @NotNull Logger logger) {
        Plugin p1;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull(userPlugins, (String)"userPlugins");
        Intrinsics.checkParameterIsNotNull((Object)immutableConfig, (String)"immutableConfig");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.immutableConfig = immutableConfig;
        this.logger = logger;
        this.ndkPlugin = this.instantiatePlugin(NDK_PLUGIN, this.immutableConfig.getEnabledErrorTypes().getNdkCrashes());
        this.anrPlugin = this.instantiatePlugin(ANR_PLUGIN, this.immutableConfig.getEnabledErrorTypes().getAnrs());
        this.rnPlugin = this.instantiatePlugin(RN_PLUGIN, this.immutableConfig.getEnabledErrorTypes().getUnhandledRejections());
        boolean bl3 = false;
        Set set = new LinkedHashSet();
        set.addAll((Collection)userPlugins);
        Plugin plugin = this.ndkPlugin;
        if (plugin != null) {
            Plugin plugin2 = plugin;
            bl2 = false;
            bl = false;
            p1 = plugin2;
            boolean bl4 = false;
            set.add(p1);
        }
        Plugin plugin3 = this.anrPlugin;
        if (plugin3 != null) {
            Plugin plugin4 = plugin3;
            bl2 = false;
            bl = false;
            p1 = plugin4;
            boolean bl5 = false;
            set.add(p1);
        }
        Plugin plugin5 = this.rnPlugin;
        if (plugin5 != null) {
            Plugin plugin6 = plugin5;
            bl2 = false;
            bl = false;
            p1 = plugin6;
            boolean bl6 = false;
            set.add(p1);
        }
        this.plugins = CollectionsKt.toSet((Iterable)set);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/bugsnag/android/PluginClient$Companion;", "", "()V", "ANR_PLUGIN", "", "NDK_PLUGIN", "RN_PLUGIN", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

