/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Map;

public final class FeatureFlag
implements Map.Entry<String, String> {
    private final String name;
    private final String variant;

    public FeatureFlag(@NonNull String name) {
        this(name, null);
    }

    public FeatureFlag(@NonNull String name, @Nullable String variant) {
        if (name == null) {
            throw new NullPointerException("FeatureFlags cannot have null name");
        }
        this.name = name;
        this.variant = variant;
    }

    public FeatureFlag(@NonNull Map.Entry<String, String> mapEntry) {
        this(mapEntry.getKey(), mapEntry.getValue());
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVariant() {
        return this.variant;
    }

    @Override
    @NonNull
    public String getKey() {
        return this.name;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.variant;
    }

    @Override
    @Nullable
    public String setValue(@Nullable String value) {
        throw new UnsupportedOperationException("FeatureFlag is immutable");
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode() ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e2 = (Map.Entry)other;
        return this.getKey().equals(e2.getKey()) && (this.getValue() == null ? e2.getValue() == null : this.getValue().equals(e2.getValue()));
    }

    public String toString() {
        return "FeatureFlag{name='" + this.name + '\'' + ", variant='" + this.variant + '\'' + '}';
    }
}

