/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import com.bugsnag.android.internal.TrimMetrics;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bJ$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000fJ\"\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/bugsnag/android/internal/StringUtils;", "", "()V", "trimMessageLength", "", "getTrimMessageLength", "()I", "stringTrimmedTo", "", "maxLength", "str", "trimNullableStringValuesTo", "Lcom/bugsnag/android/internal/TrimMetrics;", "maxStringLength", "map", "", "trimStringValuesTo", "bugsnag-android-core_release"})
public final class StringUtils {
    private static final int trimMessageLength;
    @NotNull
    public static final StringUtils INSTANCE;

    public final int getTrimMessageLength() {
        return trimMessageLength;
    }

    @NotNull
    public final String stringTrimmedTo(int maxLength, @NotNull String str) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        int excessCharCount = str.length() - maxLength;
        if (excessCharCount < trimMessageLength) {
            string = str;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = str;
            int n = 0;
            boolean bl = false;
            String string3 = string2.substring(n, maxLength);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = stringBuilder.append(string3).append("***<").append(excessCharCount).append("> CHARS TRUNCATED***").toString();
        }
        return string;
    }

    @NotNull
    public final TrimMetrics trimNullableStringValuesTo(int maxStringLength, @NotNull Map<String, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        int stringCount = 0;
        int charCount = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String) || ((String)value).length() <= maxStringLength) continue;
            entry.setValue(this.stringTrimmedTo(maxStringLength, (String)value));
            charCount += ((String)value).length() - maxStringLength;
            ++stringCount;
        }
        return new TrimMetrics(stringCount, charCount);
    }

    @NotNull
    public final TrimMetrics trimStringValuesTo(int maxStringLength, @NotNull Map<String, Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"map");
        int stringCount = 0;
        int charCount = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String) || ((String)value).length() <= maxStringLength) continue;
            entry.setValue(this.stringTrimmedTo(maxStringLength, (String)value));
            charCount += ((String)value).length() - maxStringLength;
            ++stringCount;
        }
        return new TrimMetrics(stringCount, charCount);
    }

    private StringUtils() {
    }

    static {
        StringUtils stringUtils;
        INSTANCE = stringUtils = new StringUtils();
        trimMessageLength = "***<9> CHARS TRUNCATED***".length();
    }
}

