/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SessionFilenameInfo;
import com.bugsnag.android.internal.ImmutableConfig;
import java.io.File;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

class SessionStore
extends FileStore {
    static final Comparator<File> SESSION_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File lhs, File rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return 1;
            }
            if (rhs == null) {
                return -1;
            }
            String lhsName = lhs.getName();
            String rhsName = rhs.getName();
            return lhsName.compareTo(rhsName);
        }
    };

    SessionStore(@NonNull ImmutableConfig config, @NonNull Logger logger, @Nullable FileStore.Delegate delegate) {
        super(new File((File)config.getPersistenceDirectory().getValue(), "bugsnag-sessions"), config.getMaxPersistedSessions(), SESSION_COMPARATOR, logger, delegate);
    }

    @Override
    @NonNull
    String getFilename(Object object) {
        return SessionFilenameInfo.defaultFilename();
    }

    public boolean isTooOld(File file) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -60);
        return SessionFilenameInfo.findTimestampInFilename(file) < cal.getTimeInMillis();
    }

    public Date getCreationDate(File file) {
        return new Date(SessionFilenameInfo.findTimestampInFilename(file));
    }
}

