/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.util.JsonReader;
import com.bugsnag.android.DeviceId;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SharedPrefMigrator;
import com.bugsnag.android.SynchronizedStreamableStore;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/bugsnag/android/DeviceIdStore;", "", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "sharedPrefMigrator", "Lcom/bugsnag/android/SharedPrefMigrator;", "logger", "Lcom/bugsnag/android/Logger;", "(Landroid/content/Context;Ljava/io/File;Lcom/bugsnag/android/SharedPrefMigrator;Lcom/bugsnag/android/Logger;)V", "synchronizedStreamableStore", "Lcom/bugsnag/android/SynchronizedStreamableStore;", "Lcom/bugsnag/android/DeviceId;", "loadDeviceId", "", "uuidProvider", "Lkotlin/Function0;", "Ljava/util/UUID;", "loadDeviceId$bugsnag_android_core_release", "loadDeviceIdInternal", "persistNewDeviceIdWithLock", "channel", "Ljava/nio/channels/FileChannel;", "persistNewDeviceUuid", "waitForFileLock", "Ljava/nio/channels/FileLock;", "Companion", "bugsnag-android-core_release"})
public final class DeviceIdStore {
    private final SynchronizedStreamableStore<DeviceId> synchronizedStreamableStore;
    private final File file;
    private final SharedPrefMigrator sharedPrefMigrator;
    private final Logger logger;
    private static final int MAX_FILE_LOCK_ATTEMPTS = 20;
    private static final long FILE_LOCK_WAIT_MS = 25L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String loadDeviceId() {
        return this.loadDeviceId$bugsnag_android_core_release((Function0<UUID>)((Function0)new Function0<UUID>(this){
            final /* synthetic */ DeviceIdStore this$0;

            @NotNull
            public final UUID invoke() {
                UUID uUID;
                String legacyDeviceId = DeviceIdStore.access$getSharedPrefMigrator$p(this.this$0).loadDeviceId();
                if (legacyDeviceId == null) {
                    UUID uUID2 = UUID.randomUUID();
                    uUID = uUID2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uUID2, (String)"UUID.randomUUID()");
                } else {
                    UUID uUID3 = UUID.fromString(legacyDeviceId);
                    uUID = uUID3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uUID3, (String)"UUID.fromString(legacyDeviceId)");
                }
                return uUID;
            }
            {
                this.this$0 = deviceIdStore2;
                super(0);
            }
        }));
    }

    @Nullable
    public final String loadDeviceId$bugsnag_android_core_release(@NotNull Function0<UUID> uuidProvider) {
        String string;
        Intrinsics.checkParameterIsNotNull(uuidProvider, (String)"uuidProvider");
        try {
            DeviceId deviceId2;
            DeviceId deviceId3 = deviceId2 = this.loadDeviceIdInternal();
            if ((deviceId3 != null ? deviceId3.getId() : null) == null) {
                return this.persistNewDeviceUuid(uuidProvider);
            }
            string = deviceId2.getId();
        }
        catch (Throwable exc) {
            this.logger.w("Failed to load device ID", exc);
            string = null;
        }
        return string;
    }

    private final DeviceId loadDeviceIdInternal() {
        if (this.file.length() > 0L) {
            try {
                return this.synchronizedStreamableStore.load((Function1<JsonReader, DeviceId>)((Function1)new Function1<JsonReader, DeviceId>(DeviceId.Companion){

                    @NotNull
                    public final DeviceId invoke(@NotNull JsonReader p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return ((DeviceId.Companion)this.receiver).fromReader(p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(DeviceId.Companion.class);
                    }

                    public final String getName() {
                        return "fromReader";
                    }

                    public final String getSignature() {
                        return "fromReader(Landroid/util/JsonReader;)Lcom/bugsnag/android/DeviceId;";
                    }
                }));
            }
            catch (Throwable exc) {
                this.logger.w("Failed to load device ID", exc);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String persistNewDeviceUuid(Function0<UUID> uuidProvider) {
        Object object;
        try {
            String string;
            object = this.file;
            boolean bl = false;
            object = new FileOutputStream((File)object).getChannel();
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileChannel channel = (FileChannel)object;
                boolean bl3 = false;
                FileChannel fileChannel = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"channel");
                string = this.persistNewDeviceIdWithLock(fileChannel, uuidProvider);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException exc) {
            this.logger.w("Failed to persist device ID", exc);
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String persistNewDeviceIdWithLock(FileChannel channel, Function0<UUID> uuidProvider) {
        String string;
        FileLock fileLock = this.waitForFileLock(channel);
        if (fileLock == null) {
            return null;
        }
        FileLock lock = fileLock;
        try {
            String string2;
            DeviceId deviceId2;
            DeviceId deviceId3 = deviceId2 = this.loadDeviceIdInternal();
            if ((deviceId3 != null ? deviceId3.getId() : null) != null) {
                string2 = deviceId2.getId();
            } else {
                DeviceId newId = new DeviceId(((UUID)uuidProvider.invoke()).toString());
                this.synchronizedStreamableStore.persist((DeviceId)((JsonStream.Streamable)newId));
                string2 = newId.getId();
            }
            string = string2;
        }
        finally {
            lock.release();
        }
        return string;
    }

    private final FileLock waitForFileLock(FileChannel channel) {
        int n = 20;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            try {
                return channel.tryLock();
            }
            catch (OverlappingFileLockException exc) {
                Thread.sleep(25L);
            }
        }
        return null;
    }

    @JvmOverloads
    public DeviceIdStore(@NotNull Context context, @NotNull File file, @NotNull SharedPrefMigrator sharedPrefMigrator2, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)sharedPrefMigrator2, (String)"sharedPrefMigrator");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.file = file;
        this.sharedPrefMigrator = sharedPrefMigrator2;
        this.logger = logger;
        try {
            this.file.createNewFile();
        }
        catch (Throwable exc) {
            this.logger.w("Failed to created device ID file", exc);
        }
        this.synchronizedStreamableStore = new SynchronizedStreamableStore(this.file);
    }

    public /* synthetic */ DeviceIdStore(Context context, File file, SharedPrefMigrator sharedPrefMigrator2, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file = new File(context.getFilesDir(), "device-id");
        }
        this(context, file, sharedPrefMigrator2, logger);
    }

    @JvmOverloads
    public DeviceIdStore(@NotNull Context context, @NotNull SharedPrefMigrator sharedPrefMigrator2, @NotNull Logger logger) {
        this(context, null, sharedPrefMigrator2, logger, 2, null);
    }

    public static final /* synthetic */ SharedPrefMigrator access$getSharedPrefMigrator$p(DeviceIdStore $this) {
        return $this.sharedPrefMigrator;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/bugsnag/android/DeviceIdStore$Companion;", "", "()V", "FILE_LOCK_WAIT_MS", "", "MAX_FILE_LOCK_ATTEMPTS", "", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

