/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.repackaged.dslplatform.json;

import androidx.annotation.Nullable;
import com.bugsnag.android.repackaged.dslplatform.json.JsonReader;
import com.bugsnag.android.repackaged.dslplatform.json.JsonWriter;
import com.bugsnag.android.repackaged.dslplatform.json.StringConverter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public abstract class NetConverter {
    static final JsonReader.ReadObject<URI> UriReader = new JsonReader.ReadObject<URI>(){

        @Override
        @Nullable
        public URI read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : NetConverter.deserializeUri(reader);
        }
    };
    static final JsonWriter.WriteObject<URI> UriWriter = new JsonWriter.WriteObject<URI>(){

        @Override
        public void write(JsonWriter writer, @Nullable URI value) {
            NetConverter.serializeNullable(value, writer);
        }
    };
    static final JsonReader.ReadObject<InetAddress> AddressReader = new JsonReader.ReadObject<InetAddress>(){

        @Override
        @Nullable
        public InetAddress read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : NetConverter.deserializeIp(reader);
        }
    };
    static final JsonWriter.WriteObject<InetAddress> AddressWriter = new JsonWriter.WriteObject<InetAddress>(){

        @Override
        public void write(JsonWriter writer, @Nullable InetAddress value) {
            NetConverter.serializeNullable(value, writer);
        }
    };

    public static void serializeNullable(@Nullable URI value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NetConverter.serialize(value, sw);
        }
    }

    public static void serialize(URI value, JsonWriter sw) {
        StringConverter.serializeShort(value.toString(), sw);
    }

    public static URI deserializeUri(JsonReader reader) throws IOException {
        return URI.create(reader.readString());
    }

    public static ArrayList<URI> deserializeUriCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(UriReader);
    }

    public static void deserializeUriCollection(JsonReader reader, Collection<URI> res) throws IOException {
        reader.deserializeCollection(UriReader, res);
    }

    public static ArrayList<URI> deserializeUriNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(UriReader);
    }

    public static void deserializeUriNullableCollection(JsonReader reader, Collection<URI> res) throws IOException {
        reader.deserializeNullableCollection(UriReader, res);
    }

    public static void serializeNullable(@Nullable InetAddress value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            NetConverter.serialize(value, sw);
        }
    }

    public static void serialize(InetAddress value, JsonWriter sw) {
        sw.writeByte((byte)34);
        sw.writeAscii(value.getHostAddress());
        sw.writeByte((byte)34);
    }

    public static InetAddress deserializeIp(JsonReader reader) throws IOException {
        return InetAddress.getByName(reader.readSimpleString());
    }

    public static ArrayList<InetAddress> deserializeIpCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(AddressReader);
    }

    public static void deserializeIpCollection(JsonReader reader, Collection<InetAddress> res) throws IOException {
        reader.deserializeCollection(AddressReader, res);
    }

    public static ArrayList<InetAddress> deserializeIpNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(AddressReader);
    }

    public static void deserializeIpNullableCollection(JsonReader reader, Collection<InetAddress> res) throws IOException {
        reader.deserializeNullableCollection(AddressReader, res);
    }
}

