/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.SharedPreferences;
import com.bugsnag.android.User;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/bugsnag/android/UserRepository;", "", "prefs", "Landroid/content/SharedPreferences;", "persist", "", "(Landroid/content/SharedPreferences;Z)V", "getDeviceId", "", "load", "Lcom/bugsnag/android/User;", "save", "", "user", "Companion", "bugsnag-android-core_release"})
public final class UserRepository {
    private final SharedPreferences prefs;
    private final boolean persist;
    private static final String INSTALL_ID_KEY = "install.iud";
    private static final String USER_ID_KEY = "user.id";
    private static final String USER_NAME_KEY = "user.name";
    private static final String USER_EMAIL_KEY = "user.email";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final User load() {
        String installId = this.getDeviceId();
        return this.persist ? new User(this.prefs.getString(USER_ID_KEY, installId), this.prefs.getString(USER_EMAIL_KEY, null), this.prefs.getString(USER_NAME_KEY, null)) : new User(installId, null, null);
    }

    public final void save(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        SharedPreferences.Editor editor = this.prefs.edit();
        if (this.persist) {
            editor.putString(USER_ID_KEY, user.getId()).putString(USER_NAME_KEY, user.getName()).putString(USER_EMAIL_KEY, user.getEmail());
        } else {
            editor.remove(USER_ID_KEY).remove(USER_NAME_KEY).remove(USER_EMAIL_KEY);
        }
        editor.apply();
    }

    @NotNull
    public final String getDeviceId() {
        String installId = this.prefs.getString(INSTALL_ID_KEY, null);
        if (installId == null) {
            installId = UUID.randomUUID().toString();
            this.prefs.edit().putString(INSTALL_ID_KEY, installId).apply();
        }
        return installId;
    }

    public UserRepository(@NotNull SharedPreferences prefs, boolean persist) {
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        this.prefs = prefs;
        this.persist = persist;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/bugsnag/android/UserRepository$Companion;", "", "()V", "INSTALL_ID_KEY", "", "USER_EMAIL_KEY", "USER_ID_KEY", "USER_NAME_KEY", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

