/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.EndpointConfiguration;
import com.bugsnag.android.ThreadSendPolicy;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J!\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0001\u00a2\u0006\u0002\b\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/bugsnag/android/ManifestConfigLoader;", "", "()V", "getStrArray", "", "", "data", "Landroid/os/Bundle;", "key", "default", "load", "Lcom/bugsnag/android/Configuration;", "ctx", "Landroid/content/Context;", "userSuppliedApiKey", "load$bugsnag_android_core_release", "loadAppConfig", "", "config", "loadDetectionConfig", "loadEndpointsConfig", "Companion", "bugsnag-android-core_release"})
public final class ManifestConfigLoader {
    private static final String BUGSNAG_NS = "com.bugsnag.android";
    private static final String API_KEY = "com.bugsnag.android.API_KEY";
    @NotNull
    public static final String BUILD_UUID = "com.bugsnag.android.BUILD_UUID";
    private static final String AUTO_TRACK_SESSIONS = "com.bugsnag.android.AUTO_TRACK_SESSIONS";
    private static final String AUTO_DETECT_ERRORS = "com.bugsnag.android.AUTO_DETECT_ERRORS";
    private static final String PERSIST_USER = "com.bugsnag.android.PERSIST_USER";
    private static final String SEND_THREADS = "com.bugsnag.android.SEND_THREADS";
    private static final String ENDPOINT_NOTIFY = "com.bugsnag.android.ENDPOINT_NOTIFY";
    private static final String ENDPOINT_SESSIONS = "com.bugsnag.android.ENDPOINT_SESSIONS";
    private static final String APP_VERSION = "com.bugsnag.android.APP_VERSION";
    private static final String VERSION_CODE = "com.bugsnag.android.VERSION_CODE";
    private static final String RELEASE_STAGE = "com.bugsnag.android.RELEASE_STAGE";
    private static final String ENABLED_RELEASE_STAGES = "com.bugsnag.android.ENABLED_RELEASE_STAGES";
    private static final String DISCARD_CLASSES = "com.bugsnag.android.DISCARD_CLASSES";
    private static final String PROJECT_PACKAGES = "com.bugsnag.android.PROJECT_PACKAGES";
    private static final String REDACTED_KEYS = "com.bugsnag.android.REDACTED_KEYS";
    private static final String MAX_BREADCRUMBS = "com.bugsnag.android.MAX_BREADCRUMBS";
    private static final String LAUNCH_CRASH_THRESHOLD_MS = "com.bugsnag.android.LAUNCH_CRASH_THRESHOLD_MS";
    private static final String CODE_BUNDLE_ID = "com.bugsnag.android.CODE_BUNDLE_ID";
    private static final String APP_TYPE = "com.bugsnag.android.APP_TYPE";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Configuration load(@NotNull Context ctx, @Nullable String userSuppliedApiKey) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        try {
            PackageManager packageManager = ctx.getPackageManager();
            String packageName = ctx.getPackageName();
            ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 128);
            Bundle data = ai.metaData;
            return this.load$bugsnag_android_core_release(data, userSuppliedApiKey);
        }
        catch (Exception exc) {
            throw (Throwable)new IllegalStateException("Bugsnag is unable to read config from manifest.", exc);
        }
    }

    @VisibleForTesting
    @NotNull
    public final Configuration load$bugsnag_android_core_release(@Nullable Bundle data, @Nullable String userSuppliedApiKey) {
        String string = userSuppliedApiKey;
        if (string == null) {
            Bundle bundle = data;
            string = bundle != null ? bundle.getString(API_KEY) : null;
        }
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("No Bugsnag API key set");
        }
        String apiKey = string;
        Configuration config = new Configuration(apiKey);
        if (data != null) {
            this.loadDetectionConfig(config, data);
            this.loadEndpointsConfig(config, data);
            this.loadAppConfig(config, data);
            boolean bl = false;
            boolean bl2 = false;
            Configuration $this$with = config;
            boolean bl3 = false;
            $this$with.setMaxBreadcrumbs(data.getInt(MAX_BREADCRUMBS, $this$with.getMaxBreadcrumbs()));
            $this$with.setLaunchCrashThresholdMs(data.getInt(LAUNCH_CRASH_THRESHOLD_MS, (int)$this$with.getLaunchCrashThresholdMs()));
        }
        return config;
    }

    private final void loadDetectionConfig(Configuration config, Bundle data) {
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$with = config;
        boolean bl3 = false;
        $this$with.setAutoTrackSessions(data.getBoolean(AUTO_TRACK_SESSIONS, $this$with.getAutoTrackSessions()));
        $this$with.setAutoDetectErrors(data.getBoolean(AUTO_DETECT_ERRORS, $this$with.getAutoDetectErrors()));
        $this$with.setPersistUser(data.getBoolean(PERSIST_USER, $this$with.getPersistUser()));
        String str = data.getString(SEND_THREADS);
        if (str != null) {
            $this$with.setSendThreads(ThreadSendPolicy.Companion.fromString(str));
        }
    }

    private final void loadEndpointsConfig(Configuration config, Bundle data) {
        if (data.containsKey(ENDPOINT_NOTIFY)) {
            String endpoint = data.getString(ENDPOINT_NOTIFY, config.getEndpoints().getNotify());
            String sessionEndpoint = data.getString(ENDPOINT_SESSIONS, config.getEndpoints().getSessions());
            String string = endpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"endpoint");
            String string2 = sessionEndpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sessionEndpoint");
            config.setEndpoints(new EndpointConfiguration(string, string2));
        }
    }

    private final void loadAppConfig(Configuration config, Bundle data) {
        Set set;
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$with = config;
        boolean bl3 = false;
        $this$with.setReleaseStage(data.getString(RELEASE_STAGE, config.getReleaseStage()));
        $this$with.setAppVersion(data.getString(APP_VERSION, config.getAppVersion()));
        $this$with.setAppType(data.getString(APP_TYPE, config.getAppType()));
        if (data.containsKey(VERSION_CODE)) {
            $this$with.setVersionCode(data.getInt(VERSION_CODE));
        }
        if (data.containsKey(ENABLED_RELEASE_STAGES)) {
            $this$with.setEnabledReleaseStages(this.getStrArray(data, ENABLED_RELEASE_STAGES, $this$with.getEnabledReleaseStages()));
        }
        if ((set = this.getStrArray(data, DISCARD_CLASSES, $this$with.getDiscardClasses())) == null) {
            set = SetsKt.emptySet();
        }
        $this$with.setDiscardClasses(set);
        Set set2 = this.getStrArray(data, PROJECT_PACKAGES, SetsKt.emptySet());
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        $this$with.setProjectPackages(set2);
        Set set3 = this.getStrArray(data, REDACTED_KEYS, $this$with.getRedactedKeys());
        if (set3 == null) {
            set3 = SetsKt.emptySet();
        }
        $this$with.setRedactedKeys(set3);
    }

    private final Set<String> getStrArray(Bundle data, String key, Set<String> set) {
        String delimitedStr;
        String string = delimitedStr = data.getString(key);
        List ary = string != null ? StringsKt.split$default((CharSequence)string, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null) : null;
        return ary == null ? set : CollectionsKt.toSet((Iterable)ary);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/bugsnag/android/ManifestConfigLoader$Companion;", "", "()V", "API_KEY", "", "APP_TYPE", "APP_VERSION", "AUTO_DETECT_ERRORS", "AUTO_TRACK_SESSIONS", "BUGSNAG_NS", "BUILD_UUID", "CODE_BUNDLE_ID", "DISCARD_CLASSES", "ENABLED_RELEASE_STAGES", "ENDPOINT_NOTIFY", "ENDPOINT_SESSIONS", "LAUNCH_CRASH_THRESHOLD_MS", "MAX_BREADCRUMBS", "PERSIST_USER", "PROJECT_PACKAGES", "REDACTED_KEYS", "RELEASE_STAGE", "SEND_THREADS", "VERSION_CODE", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

