/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.JsonStream;
import com.bugsnag.android.internal.DateUtils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u001c\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J(\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\"\u0010\u0017\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0012R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/bugsnag/android/ObjectJsonStreamer;", "", "()V", "redactedKeys", "", "", "getRedactedKeys", "()Ljava/util/Set;", "setRedactedKeys", "(Ljava/util/Set;)V", "arrayToStream", "", "writer", "Lcom/bugsnag/android/JsonStream;", "obj", "collectionToStream", "", "isRedactedKey", "", "key", "mapToStream", "", "shouldRedactKeys", "objectToStream", "Companion", "bugsnag-android-core_release"})
public final class ObjectJsonStreamer {
    @NotNull
    private Set<String> redactedKeys = SetsKt.setOf((Object)"password");
    @NotNull
    public static final String REDACTED_PLACEHOLDER = "[REDACTED]";
    @NotNull
    public static final String OBJECT_PLACEHOLDER = "[OBJECT]";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Set<String> getRedactedKeys() {
        return this.redactedKeys;
    }

    public final void setRedactedKeys(@NotNull Set<String> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.redactedKeys = set;
    }

    public final void objectToStream(@Nullable Object obj, @NotNull JsonStream writer, boolean shouldRedactKeys) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        if (obj == null) {
            writer.nullValue();
        } else if (obj instanceof String) {
            writer.value((String)obj);
        } else if (obj instanceof Number) {
            writer.value((Number)obj);
        } else if (obj instanceof Boolean) {
            writer.value((boolean)((Boolean)obj));
        } else if (obj instanceof JsonStream.Streamable) {
            ((JsonStream.Streamable)obj).toStream(writer);
        } else if (obj instanceof Date) {
            writer.value(DateUtils.toIso8601((Date)obj));
        } else if (obj instanceof Map) {
            this.mapToStream(writer, (Map)obj, shouldRedactKeys);
        } else if (obj instanceof Collection) {
            this.collectionToStream(writer, (Collection)obj);
        } else if (obj.getClass().isArray()) {
            this.arrayToStream(writer, obj);
        } else {
            writer.value(OBJECT_PLACEHOLDER);
        }
    }

    public static /* synthetic */ void objectToStream$default(ObjectJsonStreamer objectJsonStreamer, Object object, JsonStream jsonStream, boolean bl, int n, Object object2) throws IOException {
        if ((n & 4) != 0) {
            bl = false;
        }
        objectJsonStreamer.objectToStream(object, jsonStream, bl);
    }

    private final void mapToStream(JsonStream writer, Map<?, ?> obj, boolean shouldRedactKeys) {
        writer.beginObject();
        Iterable $this$forEach$iv = obj.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object keyObj = it.getKey();
            if (!(keyObj instanceof String)) continue;
            writer.name((String)keyObj);
            if (shouldRedactKeys && this.isRedactedKey((String)keyObj)) {
                writer.value(REDACTED_PLACEHOLDER);
                continue;
            }
            this.objectToStream(it.getValue(), writer, shouldRedactKeys);
        }
        writer.endObject();
    }

    private final void collectionToStream(JsonStream writer, Collection<?> obj) {
        writer.beginArray();
        Iterable $this$forEach$iv = obj;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            ObjectJsonStreamer.objectToStream$default(this, it, writer, false, 4, null);
        }
        writer.endArray();
    }

    private final void arrayToStream(JsonStream writer, Object obj) {
        writer.beginArray();
        int length = Array.getLength(obj);
        for (int i = 0; i < length; ++i) {
            ObjectJsonStreamer.objectToStream$default(this, Array.get(obj, i), writer, false, 4, null);
        }
        writer.endArray();
    }

    private final boolean isRedactedKey(String key) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.redactedKeys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)key, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/bugsnag/android/ObjectJsonStreamer$Companion;", "", "()V", "OBJECT_PLACEHOLDER", "", "REDACTED_PLACEHOLDER", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

