/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import com.bugsnag.android.internal.DateUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000)\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/bugsnag/android/internal/DateUtils;", "", "()V", "iso8601Format", "Ljava/text/DateFormat;", "getIso8601Format", "()Ljava/text/DateFormat;", "iso8601Holder", "com/bugsnag/android/internal/DateUtils$iso8601Holder$1", "Lcom/bugsnag/android/internal/DateUtils$iso8601Holder$1;", "fromIso8601", "Ljava/util/Date;", "date", "", "toIso8601", "bugsnag-android-core_release"})
public final class DateUtils {
    private static final iso8601Holder.1 iso8601Holder;
    @NotNull
    public static final DateUtils INSTANCE;

    private final DateFormat getIso8601Format() {
        Object t = iso8601Holder.get();
        boolean bl = false;
        boolean bl2 = false;
        if (t == null) {
            boolean bl3 = false;
            String string = "Unable to find valid dateformatter";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (DateFormat)t;
    }

    @JvmStatic
    @NotNull
    public static final String toIso8601(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        String string = INSTANCE.getIso8601Format().format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"iso8601Format.format(date)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Date fromIso8601(@NotNull String date) {
        Date date2;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        try {
            Date date3 = INSTANCE.getIso8601Format().parse(date);
            if (date3 == null) {
                throw (Throwable)new ParseException("DateFormat.parse returned null", 0);
            }
            date2 = date3;
        }
        catch (ParseException exc) {
            throw (Throwable)new IllegalArgumentException("Failed to parse timestamp", exc);
        }
        return date2;
    }

    private DateUtils() {
    }

    static {
        DateUtils dateUtils;
        INSTANCE = dateUtils = new DateUtils();
        iso8601Holder = new ThreadLocal<DateFormat>(){

            @NotNull
            protected DateFormat initialValue() {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
                boolean bl = false;
                boolean bl2 = false;
                SimpleDateFormat $this$apply = simpleDateFormat;
                boolean bl3 = false;
                $this$apply.setTimeZone(TimeZone.getTimeZone("UTC"));
                return simpleDateFormat;
            }
        };
    }
}

