/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.net.TrafficStats;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.DefaultDeliveryKt;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryHeadersKt;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeliveryStatus;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Session;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\nH\u0002J.\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0015H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006'"}, d2={"Lcom/bugsnag/android/DefaultDelivery;", "Lcom/bugsnag/android/Delivery;", "connectivity", "Lcom/bugsnag/android/Connectivity;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Lcom/bugsnag/android/Logger;)V", "getLogger", "()Lcom/bugsnag/android/Logger;", "deliver", "Lcom/bugsnag/android/DeliveryStatus;", "payload", "Lcom/bugsnag/android/EventPayload;", "deliveryParams", "Lcom/bugsnag/android/DeliveryParams;", "Lcom/bugsnag/android/Session;", "urlString", "", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "headers", "", "getDeliveryStatus", "responseCode", "", "getDeliveryStatus$bugsnag_android_core_release", "isUnrecoverableStatusCode", "", "logRequestInfo", "", "code", "conn", "Ljava/net/HttpURLConnection;", "status", "makeRequest", "url", "Ljava/net/URL;", "json", "", "bugsnag-android-core_release"})
public final class DefaultDelivery
implements Delivery {
    private final Connectivity connectivity;
    @NotNull
    private final Logger logger;

    @Override
    @NotNull
    public DeliveryStatus deliver(@NotNull Session payload, @NotNull DeliveryParams deliveryParams) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)deliveryParams, (String)"deliveryParams");
        DeliveryStatus status = this.deliver(deliveryParams.getEndpoint(), payload, deliveryParams.getHeaders());
        this.logger.i("Session API request finished with status " + (Object)((Object)status));
        return status;
    }

    @Override
    @NotNull
    public DeliveryStatus deliver(@NotNull EventPayload payload, @NotNull DeliveryParams deliveryParams) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)deliveryParams, (String)"deliveryParams");
        DeliveryStatus status = this.deliver(deliveryParams.getEndpoint(), payload, deliveryParams.getHeaders());
        this.logger.i("Error API request finished with status " + (Object)((Object)status));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DeliveryStatus deliver(@NotNull String urlString, @NotNull JsonStream.Streamable streamable, @NotNull Map<String, String> headers) {
        Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
        Intrinsics.checkParameterIsNotNull((Object)streamable, (String)"streamable");
        Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
        TrafficStats.setThreadStatsTag((int)1);
        if (this.connectivity != null && !this.connectivity.hasNetworkConnection()) {
            return DeliveryStatus.UNDELIVERED;
        }
        HttpURLConnection conn = null;
        try {
            byte[] json = DefaultDeliveryKt.serializeJsonPayload(streamable);
            conn = this.makeRequest(new URL(urlString), json, headers);
            int responseCode = conn.getResponseCode();
            DeliveryStatus status = this.getDeliveryStatus$bugsnag_android_core_release(responseCode);
            this.logRequestInfo(responseCode, conn, status);
            DeliveryStatus deliveryStatus = status;
            return deliveryStatus;
        }
        catch (OutOfMemoryError oom) {
            this.logger.w("Encountered OOM delivering payload, falling back to persist on disk", oom);
            DeliveryStatus deliveryStatus = DeliveryStatus.UNDELIVERED;
            return deliveryStatus;
        }
        catch (IOException exception) {
            this.logger.w("IOException encountered in request", exception);
            DeliveryStatus deliveryStatus = DeliveryStatus.UNDELIVERED;
            return deliveryStatus;
        }
        catch (Exception exception) {
            this.logger.w("Unexpected error delivering payload", exception);
            DeliveryStatus deliveryStatus = DeliveryStatus.FAILURE;
            return deliveryStatus;
        }
        finally {
            block10: {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection == null) break block10;
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final HttpURLConnection makeRequest(URL url, byte[] json, Map<String, String> headers) {
        boolean bl;
        Object object;
        URLConnection uRLConnection = url.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setDoOutput(true);
        conn.setFixedLengthStreamingMode(json.length);
        String string = DeliveryHeadersKt.computeSha1Digest(json);
        if (string != null) {
            object = string;
            bl = false;
            boolean bl2 = false;
            String digest = object;
            boolean bl3 = false;
            conn.addRequestProperty("Bugsnag-Integrity", digest);
        }
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv;
        boolean digest = false;
        Iterator<Map.Entry<String, String>> bl3 = object2.entrySet().iterator();
        while (bl3.hasNext()) {
            void key;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = bl3.next();
            boolean bl4 = false;
            Map.Entry<String, String> entry = $dstr$key$value;
            boolean bl5 = false;
            String string2 = entry.getKey();
            entry = $dstr$key$value;
            bl5 = false;
            String value = entry.getValue();
            if (value == null) continue;
            conn.addRequestProperty((String)key, value);
        }
        object = conn.getOutputStream();
        bl = false;
        object2 = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl6 = false;
            it.write(json);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logRequestInfo(int code, HttpURLConnection conn, DeliveryStatus status) {
        int n;
        Closeable it2;
        boolean bl;
        Closeable closeable;
        boolean bl2;
        DefaultDelivery $this$runCatching2;
        Object object;
        DefaultDelivery defaultDelivery = this;
        boolean bl3 = false;
        try {
            object = Result.Companion;
            $this$runCatching2 = defaultDelivery;
            boolean bl4 = false;
            $this$runCatching2.logger.i("Request completed with code " + code + ", " + "message: " + conn.getResponseMessage() + ", " + "headers: " + conn.getHeaderFields());
            $this$runCatching2 = Unit.INSTANCE;
            bl4 = false;
            object = Result.constructor-impl((Object)$this$runCatching2);
        }
        catch (Throwable $this$runCatching2) {
            Result.Companion bl4 = Result.Companion;
            bl2 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
        }
        defaultDelivery = this;
        bl3 = false;
        try {
            object = Result.Companion;
            $this$runCatching2 = defaultDelivery;
            boolean bl5 = false;
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"conn.inputStream");
            Closeable closeable2 = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl6 = false;
            closeable = closeable2;
            int n2 = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n2 = 8192;
            bl = false;
            closeable2 = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
            boolean bl7 = false;
            Throwable throwable = null;
            try {
                it2 = (BufferedReader)closeable2;
                n = 0;
                $this$runCatching2.logger.d("Received request response: " + TextStreamsKt.readText((Reader)((Reader)it2)));
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            $this$runCatching2 = Unit.INSTANCE;
            bl5 = false;
            object = Result.constructor-impl((Object)$this$runCatching2);
        }
        catch (Throwable $this$runCatching3) {
            Result.Companion bl5 = Result.Companion;
            bl2 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching3));
        }
        defaultDelivery = this;
        bl3 = false;
        try {
            object = Result.Companion;
            $this$runCatching2 = defaultDelivery;
            boolean bl8 = false;
            if (status != DeliveryStatus.DELIVERED) {
                InputStream inputStream = conn.getErrorStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"conn.errorStream");
                Closeable closeable3 = inputStream;
                Charset charset = Charsets.UTF_8;
                boolean bl9 = false;
                it2 = closeable3;
                n = 0;
                it2 = new InputStreamReader((InputStream)it2, charset);
                n = 8192;
                bl = false;
                closeable3 = it2 instanceof BufferedReader ? (BufferedReader)it2 : new BufferedReader((Reader)it2, n);
                boolean bl10 = false;
                Throwable throwable = null;
                try {
                    it2 = (BufferedReader)closeable3;
                    boolean bl11 = false;
                    $this$runCatching2.logger.w("Request error details: " + TextStreamsKt.readText((Reader)((Reader)it2)));
                    closeable = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable);
                }
            }
            Unit unit = Unit.INSTANCE;
            boolean bl12 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl2 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @NotNull
    public final DeliveryStatus getDeliveryStatus$bugsnag_android_core_release(int responseCode) {
        int n = responseCode;
        return 200 <= n && 299 >= n ? DeliveryStatus.DELIVERED : (this.isUnrecoverableStatusCode(responseCode) ? DeliveryStatus.FAILURE : DeliveryStatus.UNDELIVERED);
    }

    private final boolean isUnrecoverableStatusCode(int responseCode) {
        int n = responseCode;
        return 400 <= n && 499 >= n && responseCode != 408 && responseCode != 429;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public DefaultDelivery(@Nullable Connectivity connectivity, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.connectivity = connectivity;
        this.logger = logger;
    }
}

