/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.BreadcrumbInternal;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.DateUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class Breadcrumb
implements JsonStream.Streamable {
    final BreadcrumbInternal impl;
    private final Logger logger;

    Breadcrumb(@NonNull String message, @NonNull Logger logger) {
        this.impl = new BreadcrumbInternal(message);
        this.logger = logger;
    }

    Breadcrumb(@NonNull String message, @NonNull BreadcrumbType type, @Nullable Map<String, Object> metadata, @NonNull Date timestamp, @NonNull Logger logger) {
        this.impl = new BreadcrumbInternal(message, type, metadata, timestamp);
        this.logger = logger;
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to breadcrumb." + property + ", ignoring");
    }

    public void setMessage(@NonNull String message) {
        if (message != null) {
            this.impl.message = message;
        } else {
            this.logNull("message");
        }
    }

    @NonNull
    public String getMessage() {
        return this.impl.message;
    }

    public void setType(@NonNull BreadcrumbType type) {
        if (type != null) {
            this.impl.type = type;
        } else {
            this.logNull("type");
        }
    }

    @NonNull
    public BreadcrumbType getType() {
        return this.impl.type;
    }

    public void setMetadata(@Nullable Map<String, Object> metadata) {
        this.impl.metadata = metadata;
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.impl.metadata;
    }

    @NonNull
    public Date getTimestamp() {
        return this.impl.timestamp;
    }

    @NonNull
    String getStringTimestamp() {
        return DateUtils.toIso8601(this.impl.timestamp);
    }

    @Override
    public void toStream(@NonNull JsonStream stream) throws IOException {
        this.impl.toStream(stream);
    }
}

