/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.os.Build;
import android.os.storage.StorageManager;
import androidx.annotation.NonNull;
import com.bugsnag.android.AppDataCollector;
import com.bugsnag.android.Async;
import com.bugsnag.android.DefaultDelivery;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeviceDataCollector;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.HandledState;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.SessionTracker;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

class InternalReportDelegate
implements FileStore.Delegate {
    static final String INTERNAL_DIAGNOSTICS_TAB = "BugsnagDiagnostics";
    final Logger logger;
    final ImmutableConfig immutableConfig;
    final StorageManager storageManager;
    final AppDataCollector appDataCollector;
    final DeviceDataCollector deviceDataCollector;
    final Context appContext;
    final SessionTracker sessionTracker;
    final Notifier notifier;

    InternalReportDelegate(Context context, Logger logger, ImmutableConfig immutableConfig, StorageManager storageManager, AppDataCollector appDataCollector, DeviceDataCollector deviceDataCollector, SessionTracker sessionTracker, Notifier notifier) {
        this.logger = logger;
        this.immutableConfig = immutableConfig;
        this.storageManager = storageManager;
        this.appDataCollector = appDataCollector;
        this.deviceDataCollector = deviceDataCollector;
        this.appContext = context;
        this.sessionTracker = sessionTracker;
        this.notifier = notifier;
    }

    @Override
    public void onErrorIOFailure(Exception exc, File errorFile, String context) {
        HandledState handledState = HandledState.newInstance("unhandledException");
        Event err = new Event(exc, this.immutableConfig, handledState, this.logger);
        err.setContext(context);
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "canRead", errorFile.canRead());
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "canWrite", errorFile.canWrite());
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "exists", errorFile.exists());
        long usableSpace = this.appContext.getCacheDir().getUsableSpace();
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "usableSpace", usableSpace);
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "filename", errorFile.getName());
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "fileLength", errorFile.length());
        this.recordStorageCacheBehavior(err);
        this.reportInternalBugsnagError(err);
    }

    void recordStorageCacheBehavior(Event event) {
        if (Build.VERSION.SDK_INT >= 26) {
            File cacheDir = this.appContext.getCacheDir();
            File errDir = new File(cacheDir, "bugsnag-errors");
            try {
                boolean tombstone = this.storageManager.isCacheBehaviorTombstone(errDir);
                boolean group = this.storageManager.isCacheBehaviorGroup(errDir);
                event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "cacheTombstone", tombstone);
                event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "cacheGroup", group);
            }
            catch (IOException exc) {
                this.logger.w("Failed to record cache behaviour, skipping diagnostics", exc);
            }
        }
    }

    void reportInternalBugsnagError(@NonNull Event event) {
        event.setApp(this.appDataCollector.generateAppWithState());
        event.setDevice(this.deviceDataCollector.generateDeviceWithState(new Date().getTime()));
        event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "notifierName", this.notifier.getName());
        event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "notifierVersion", this.notifier.getVersion());
        event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "apiKey", this.immutableConfig.getApiKey());
        final EventPayload eventPayload = new EventPayload(null, event, this.notifier);
        try {
            Async.run(new Runnable(){

                @Override
                public void run() {
                    try {
                        Delivery delivery = InternalReportDelegate.this.immutableConfig.getDelivery();
                        DeliveryParams params = InternalReportDelegate.this.immutableConfig.getErrorApiDeliveryParams();
                        if (delivery instanceof DefaultDelivery) {
                            Map<String, String> headers = params.getHeaders();
                            headers.put("Bugsnag-Internal-Error", "true");
                            headers.remove("Bugsnag-Api-Key");
                            DefaultDelivery defaultDelivery = (DefaultDelivery)delivery;
                            defaultDelivery.deliver(params.getEndpoint(), eventPayload, headers);
                        }
                    }
                    catch (Exception exception) {
                        InternalReportDelegate.this.logger.w("Failed to report internal event to Bugsnag", exception);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

