/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Connectivity;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeliveryStatus;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Session;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0015J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/bugsnag/android/DefaultDelivery;", "Lcom/bugsnag/android/Delivery;", "connectivity", "Lcom/bugsnag/android/Connectivity;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Lcom/bugsnag/android/Logger;)V", "getLogger", "()Lcom/bugsnag/android/Logger;", "deliver", "Lcom/bugsnag/android/DeliveryStatus;", "payload", "Lcom/bugsnag/android/EventPayload;", "deliveryParams", "Lcom/bugsnag/android/DeliveryParams;", "Lcom/bugsnag/android/Session;", "urlString", "", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "headers", "", "getDeliveryStatus", "responseCode", "", "getDeliveryStatus$bugsnag_android_core_release", "logRequestInfo", "", "code", "conn", "Ljava/net/HttpURLConnection;", "status", "bugsnag-android-core_release"})
public final class DefaultDelivery
implements Delivery {
    private final Connectivity connectivity;
    @NotNull
    private final Logger logger;

    @Override
    @NotNull
    public DeliveryStatus deliver(@NotNull Session payload, @NotNull DeliveryParams deliveryParams) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)deliveryParams, (String)"deliveryParams");
        DeliveryStatus status = this.deliver(deliveryParams.getEndpoint(), payload, deliveryParams.getHeaders());
        this.logger.i("Session API request finished with status " + (Object)((Object)status));
        return status;
    }

    @Override
    @NotNull
    public DeliveryStatus deliver(@NotNull EventPayload payload, @NotNull DeliveryParams deliveryParams) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)deliveryParams, (String)"deliveryParams");
        DeliveryStatus status = this.deliver(deliveryParams.getEndpoint(), payload, deliveryParams.getHeaders());
        this.logger.i("Error API request finished with status " + (Object)((Object)status));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DeliveryStatus deliver(@NotNull String urlString, @NotNull JsonStream.Streamable streamable, @NotNull Map<String, String> headers) {
        Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
        Intrinsics.checkParameterIsNotNull((Object)streamable, (String)"streamable");
        Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
        if (this.connectivity != null && !this.connectivity.hasNetworkConnection()) {
            return DeliveryStatus.UNDELIVERED;
        }
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            conn = (HttpURLConnection)uRLConnection;
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(0);
            conn.addRequestProperty("Content-Type", "application/json");
            Map<String, String> $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl3 = false;
                String key = entry.getKey();
                entry = $dstr$key$value;
                bl3 = false;
                String value = entry.getValue();
                conn.addRequestProperty(key, value);
            }
            JsonStream stream = null;
            try {
                OutputStream out = conn.getOutputStream();
                Charset charset = Charset.forName("UTF-8");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, charset));
                stream = new JsonStream(writer);
                streamable.toStream(stream);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
            int responseCode = conn.getResponseCode();
            DeliveryStatus status = this.getDeliveryStatus$bugsnag_android_core_release(responseCode);
            this.logRequestInfo(responseCode, conn, status);
            DeliveryStatus deliveryStatus = status;
            return deliveryStatus;
        }
        catch (IOException exception) {
            this.logger.w("IOException encountered in request", exception);
            DeliveryStatus deliveryStatus = DeliveryStatus.UNDELIVERED;
            return deliveryStatus;
        }
        catch (Exception exception) {
            this.logger.w("Unexpected error delivering payload", exception);
            DeliveryStatus deliveryStatus = DeliveryStatus.FAILURE;
            return deliveryStatus;
        }
        finally {
            IOUtils.close(conn);
        }
    }

    private final void logRequestInfo(int code, HttpURLConnection conn, DeliveryStatus status) {
        this.logger.i("Request completed with code " + code + ", " + "message: " + conn.getResponseMessage() + ", " + "headers: " + conn.getHeaderFields());
        if (status != DeliveryStatus.DELIVERED) {
            InputStream inputStream = conn.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"conn.errorStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = inputStream2;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            String errBody = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
            this.logger.w("Request error details: " + errBody);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DeliveryStatus getDeliveryStatus$bugsnag_android_core_release(int responseCode) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)new IntRange(400, 499);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it != 408 && it != 429)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unrecoverableCodes = (List)destination$iv$iv;
        int n = responseCode;
        int n2 = n;
        return 200 <= n2 && 299 >= n2 ? DeliveryStatus.DELIVERED : (unrecoverableCodes.contains(n) ? DeliveryStatus.FAILURE : DeliveryStatus.UNDELIVERED);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public DefaultDelivery(@Nullable Connectivity connectivity, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.connectivity = connectivity;
        this.logger = logger;
    }
}

