/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class BugsnagException
extends Throwable
implements JsonStream.Streamable {
    private static final long serialVersionUID = 5068182621179433346L;
    private String name;
    private String message;
    private final List<Map<String, Object>> customStackframes;
    private String type = "android";
    private JsonStream.Streamable streamable;
    private String[] projectPackages;

    public BugsnagException(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] frames) {
        super(message);
        this.setStackTrace(frames);
        this.name = name;
        this.customStackframes = null;
    }

    BugsnagException(@NonNull Throwable exc) {
        super(exc.getMessage());
        if (exc instanceof JsonStream.Streamable) {
            this.streamable = (JsonStream.Streamable)((Object)exc);
            this.name = "";
        } else {
            this.name = exc.getClass().getName();
        }
        this.setStackTrace(exc.getStackTrace());
        this.initCause(exc.getCause());
        this.customStackframes = null;
    }

    BugsnagException(@NonNull String name, @NonNull String message, @NonNull List<Map<String, Object>> customStackframes) {
        super(message);
        this.setStackTrace(new StackTraceElement[0]);
        this.name = name;
        this.customStackframes = customStackframes;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    @Override
    @NonNull
    public String getMessage() {
        return this.message != null ? this.message : super.getMessage();
    }

    public void setMessage(@NonNull String message) {
        this.message = message;
    }

    @NonNull
    String getType() {
        return this.type;
    }

    void setType(@NonNull String type) {
        this.type = type;
    }

    @Override
    public void toStream(@NonNull JsonStream stream) throws IOException {
        if (this.streamable != null) {
            this.streamable.toStream(stream);
        } else {
            List<Map<String, Object>> frames = this.customStackframes;
            Stacktrace stacktrace = frames != null ? new Stacktrace(frames) : new Stacktrace(this.getStackTrace(), this.projectPackages);
            stream.beginObject();
            stream.name("errorClass").value(this.getName());
            stream.name("message").value(this.getLocalizedMessage());
            stream.name("type").value(this.type);
            stream.name("stacktrace").value(stacktrace);
            stream.endObject();
        }
    }

    void setProjectPackages(String[] projectPackages) {
        this.projectPackages = projectPackages;
    }
}

