/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;

class CachedThread
implements JsonStream.Streamable {
    private final long id;
    private final String name;
    private final String type;
    private final boolean isErrorReportingThread;
    private final StackTraceElement[] frames;
    private final Configuration config;

    CachedThread(Configuration config, long id, String name, String type, boolean isErrorReportingThread, StackTraceElement[] frames) {
        this.id = id;
        this.config = config;
        this.name = name;
        this.type = type;
        this.isErrorReportingThread = isErrorReportingThread;
        this.frames = frames;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("id").value(this.id);
        writer.name("name").value(this.name);
        writer.name("type").value(this.type);
        writer.name("stacktrace").value(new Stacktrace(this.frames, this.config.getProjectPackages()));
        if (this.isErrorReportingThread) {
            writer.name("errorReportingThread").value(true);
        }
        writer.endObject();
    }
}

