/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.AppData;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.Session;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SessionTrackingPayload
implements JsonStream.Streamable {
    private final Notifier notifier;
    private final Session session;
    private final Map<String, Object> deviceDataSummary;
    private final Map<String, Object> appDataSummary;
    private final List<File> files;

    SessionTrackingPayload(Session session, List<File> files, AppData appData, DeviceData deviceData) {
        this.appDataSummary = appData.getAppDataSummary();
        this.deviceDataSummary = deviceData.getDeviceDataSummary();
        this.notifier = Notifier.getInstance();
        this.session = session;
        this.files = files;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("notifier").value(this.notifier);
        writer.name("app").value(this.appDataSummary);
        writer.name("device").value(this.deviceDataSummary);
        writer.name("sessions").beginArray();
        if (this.session == null) {
            for (File file : this.files) {
                writer.value(file);
            }
        } else {
            writer.value(this.session);
        }
        writer.endArray();
        writer.endObject();
    }

    Session getSession() {
        return this.session;
    }

    Map<String, Object> getDevice() {
        return this.deviceDataSummary;
    }
}

