/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

class ObjectJsonStreamer {
    private static final String FILTERED_PLACEHOLDER = "[FILTERED]";
    private static final String OBJECT_PLACEHOLDER = "[OBJECT]";
    String[] filters = new String[]{"password"};

    ObjectJsonStreamer() {
    }

    void objectToStream(@Nullable Object obj, @NonNull JsonStream writer) throws IOException {
        if (obj == null) {
            writer.nullValue();
        } else if (obj instanceof String) {
            writer.value((String)obj);
        } else if (obj instanceof Number) {
            writer.value((Number)obj);
        } else if (obj instanceof Boolean) {
            writer.value((Boolean)obj);
        } else if (obj instanceof Map) {
            writer.beginObject();
            for (Map.Entry o : ((Map)obj).entrySet()) {
                Map.Entry entry = o;
                Object keyObj = entry.getKey();
                if (!(keyObj instanceof String)) continue;
                String key = (String)keyObj;
                writer.name(key);
                if (this.shouldFilter(key)) {
                    writer.value(FILTERED_PLACEHOLDER);
                    continue;
                }
                this.objectToStream(entry.getValue(), writer);
            }
            writer.endObject();
        } else if (obj instanceof Collection) {
            writer.beginArray();
            for (Object entry : (Collection)obj) {
                this.objectToStream(entry, writer);
            }
            writer.endArray();
        } else if (obj.getClass().isArray()) {
            writer.beginArray();
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                this.objectToStream(Array.get(obj, i), writer);
            }
            writer.endArray();
        } else {
            writer.value(OBJECT_PLACEHOLDER);
        }
    }

    private boolean shouldFilter(@Nullable String key) {
        if (this.filters == null || key == null) {
            return false;
        }
        for (String filter : this.filters) {
            if (!key.contains(filter)) continue;
            return true;
        }
        return false;
    }
}

