/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SessionTracker;
import java.util.HashMap;
import java.util.Map;

class AppData {
    private static final long startTimeMs = SystemClock.elapsedRealtime();
    static final String RELEASE_STAGE_DEVELOPMENT = "development";
    static final String RELEASE_STAGE_PRODUCTION = "production";
    private final Context appContext;
    private final Configuration config;
    private final SessionTracker sessionTracker;
    private final String packageName;
    private String binaryArch = null;
    @Nullable
    final String appName;
    @Nullable
    private PackageInfo packageInfo;
    @Nullable
    private ApplicationInfo applicationInfo;
    private PackageManager packageManager;

    AppData(Context appContext, PackageManager packageManager, Configuration config, SessionTracker sessionTracker) {
        this.appContext = appContext;
        this.packageManager = packageManager;
        this.config = config;
        this.sessionTracker = sessionTracker;
        this.packageName = appContext.getPackageName();
        try {
            this.packageManager = packageManager;
            this.packageInfo = this.packageManager.getPackageInfo(this.packageName, 0);
            this.applicationInfo = this.packageManager.getApplicationInfo(this.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException exception) {
            Logger.warn("Could not retrieve package/application information for " + this.packageName);
        }
        this.appName = this.getAppName();
    }

    Map<String, Object> getAppDataSummary() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.calculateNotifierType());
        map.put("releaseStage", this.guessReleaseStage());
        map.put("version", this.calculateVersionName());
        map.put("versionCode", this.calculateVersionCode());
        map.put("codeBundleId", this.config.getCodeBundleId());
        return map;
    }

    Map<String, Object> getAppData() {
        Map<String, Object> map = this.getAppDataSummary();
        map.put("id", this.packageName);
        map.put("buildUUID", this.config.getBuildUUID());
        map.put("duration", AppData.getDurationMs());
        map.put("durationInForeground", this.calculateDurationInForeground());
        map.put("inForeground", this.sessionTracker.isInForeground());
        map.put("packageName", this.packageName);
        map.put("binaryArch", this.binaryArch);
        return map;
    }

    Map<String, Object> getAppDataMetaData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.appName);
        map.put("packageName", this.packageName);
        map.put("versionName", this.calculateVersionName());
        map.put("activeScreen", this.getActiveScreenClass());
        map.put("memoryUsage", this.getMemoryUsage());
        map.put("lowMemory", this.isLowMemory());
        return map;
    }

    void setBinaryArch(String binaryArch) {
        this.binaryArch = binaryArch;
    }

    static long getDurationMs() {
        return SystemClock.elapsedRealtime() - startTimeMs;
    }

    private long calculateDurationInForeground() {
        long nowMs = System.currentTimeMillis();
        return this.sessionTracker.getDurationInForegroundMs(nowMs);
    }

    String getActiveScreenClass() {
        return this.sessionTracker.getContextActivity();
    }

    @NonNull
    private String calculateNotifierType() {
        String notifierType = this.config.getNotifierType();
        if (notifierType != null) {
            return notifierType;
        }
        return "android";
    }

    @Nullable
    private Integer calculateVersionCode() {
        if (this.packageInfo != null) {
            return this.packageInfo.versionCode;
        }
        return null;
    }

    @Nullable
    private String calculateVersionName() {
        String configAppVersion = this.config.getAppVersion();
        if (configAppVersion != null) {
            return configAppVersion;
        }
        if (this.packageInfo != null) {
            return this.packageInfo.versionName;
        }
        return null;
    }

    @NonNull
    String guessReleaseStage() {
        String configStage = this.config.getReleaseStage();
        if (configStage != null) {
            return configStage;
        }
        if (this.applicationInfo != null && (this.applicationInfo.flags & 2) != 0) {
            return RELEASE_STAGE_DEVELOPMENT;
        }
        return RELEASE_STAGE_PRODUCTION;
    }

    @Nullable
    private String getAppName() {
        if (this.packageManager != null && this.applicationInfo != null) {
            return this.packageManager.getApplicationLabel(this.applicationInfo).toString();
        }
        return null;
    }

    private long getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    @Nullable
    private Boolean isLowMemory() {
        try {
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            if (activityManager != null) {
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                activityManager.getMemoryInfo(memInfo);
                return memInfo.lowMemory;
            }
        }
        catch (Exception exception) {
            Logger.warn("Could not check lowMemory status");
        }
        return null;
    }
}

