/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.Logger;
import com.bugsnag.android.ThreadSafe;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

@ThreadSafe
class DeviceData {
    private static final String[] ROOT_INDICATORS = new String[]{"/system/xbin/su", "/system/bin/su", "/system/app/Superuser.apk", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/SuperSU", "/system/xbin/daemonsu", "/su/bin"};
    private static final String INSTALL_ID_KEY = "install.iud";
    private final boolean emulator;
    private final Context appContext;
    private final Connectivity connectivity;
    private final Resources resources;
    private final SharedPreferences sharedPrefs;
    private final DisplayMetrics displayMetrics;
    private final String id;
    private final boolean rooted;
    @Nullable
    final Float screenDensity;
    @Nullable
    final Integer dpi;
    @Nullable
    final String screenResolution;
    @NonNull
    final String locale;
    @NonNull
    final String[] cpuAbi;

    DeviceData(Connectivity connectivity, Context appContext, Resources resources, SharedPreferences sharedPreferences) {
        this.connectivity = connectivity;
        this.appContext = appContext;
        this.resources = resources;
        this.sharedPrefs = sharedPreferences;
        this.displayMetrics = resources != null ? resources.getDisplayMetrics() : null;
        this.screenDensity = this.getScreenDensity();
        this.dpi = this.getScreenDensityDpi();
        this.screenResolution = this.getScreenResolution();
        this.locale = this.getLocale();
        this.cpuAbi = this.getCpuAbi();
        this.emulator = this.isEmulator();
        this.id = this.retrieveUniqueInstallId();
        this.rooted = this.isRooted();
    }

    Map<String, Object> getDeviceDataSummary() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("manufacturer", Build.MANUFACTURER);
        map.put("model", Build.MODEL);
        map.put("jailbroken", this.rooted);
        map.put("osName", "android");
        map.put("osVersion", Build.VERSION.RELEASE);
        map.put("cpuAbi", this.cpuAbi);
        HashMap<String, Object> versions = new HashMap<String, Object>();
        versions.put("androidApiLevel", Build.VERSION.SDK_INT);
        versions.put("osBuild", Build.DISPLAY);
        map.put("runtimeVersions", versions);
        return map;
    }

    Map<String, Object> getDeviceData() {
        Map<String, Object> map = this.getDeviceDataSummary();
        map.put("id", this.id);
        map.put("freeMemory", this.calculateFreeMemory());
        map.put("totalMemory", DeviceData.calculateTotalMemory());
        map.put("freeDisk", this.calculateFreeDisk());
        map.put("orientation", this.calculateOrientation());
        return map;
    }

    Map<String, Object> getDeviceMetaData() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("batteryLevel", this.getBatteryLevel());
        map.put("charging", this.isCharging());
        map.put("locationStatus", this.getLocationStatus());
        map.put("networkAccess", this.getNetworkAccess());
        map.put("time", this.getTime());
        map.put("brand", Build.BRAND);
        map.put("locale", this.locale);
        map.put("screenDensity", this.screenDensity);
        map.put("dpi", this.dpi);
        map.put("emulator", this.emulator);
        map.put("screenResolution", this.screenResolution);
        return map;
    }

    String getId() {
        return this.id;
    }

    private boolean isRooted() {
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        try {
            for (String candidate : ROOT_INDICATORS) {
                if (!new File(candidate).exists()) continue;
                return true;
            }
        }
        catch (Exception ignore) {
            return false;
        }
        return false;
    }

    private boolean isEmulator() {
        String fingerprint = Build.FINGERPRINT;
        return fingerprint.startsWith("unknown") || fingerprint.contains("generic") || fingerprint.contains("vbox");
    }

    @Nullable
    private Float getScreenDensity() {
        if (this.displayMetrics != null) {
            return Float.valueOf(this.displayMetrics.density);
        }
        return null;
    }

    @Nullable
    private Integer getScreenDensityDpi() {
        if (this.displayMetrics != null) {
            return this.displayMetrics.densityDpi;
        }
        return null;
    }

    @Nullable
    private String getScreenResolution() {
        if (this.displayMetrics != null) {
            int max = Math.max(this.displayMetrics.widthPixels, this.displayMetrics.heightPixels);
            int min = Math.min(this.displayMetrics.widthPixels, this.displayMetrics.heightPixels);
            return String.format(Locale.US, "%dx%d", max, min);
        }
        return null;
    }

    static long calculateTotalMemory() {
        Runtime runtime = Runtime.getRuntime();
        if (runtime.maxMemory() != Long.MAX_VALUE) {
            return runtime.maxMemory();
        }
        return runtime.totalMemory();
    }

    @NonNull
    private String getLocale() {
        return Locale.getDefault().toString();
    }

    @Nullable
    private String retrieveUniqueInstallId() {
        String installId = this.sharedPrefs.getString(INSTALL_ID_KEY, null);
        if (installId == null) {
            installId = UUID.randomUUID().toString();
            this.sharedPrefs.edit().putString(INSTALL_ID_KEY, installId).apply();
        }
        return installId;
    }

    @NonNull
    private String[] getCpuAbi() {
        if (Build.VERSION.SDK_INT >= 21) {
            return SupportedAbiWrapper.getSupportedAbis();
        }
        return Abi2Wrapper.getAbi1andAbi2();
    }

    @Nullable
    private Long calculateFreeDisk() {
        try {
            StatFs externalStat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long externalBytesAvailable = (long)externalStat.getBlockSize() * (long)externalStat.getBlockCount();
            StatFs internalStat = new StatFs(Environment.getDataDirectory().getPath());
            long internalBytesAvailable = (long)internalStat.getBlockSize() * (long)internalStat.getBlockCount();
            return Math.min(internalBytesAvailable, externalBytesAvailable);
        }
        catch (Exception exception) {
            Logger.warn("Could not get freeDisk");
            return null;
        }
    }

    private long calculateFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        if (runtime.maxMemory() != Long.MAX_VALUE) {
            return runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        }
        return runtime.freeMemory();
    }

    @Nullable
    private String calculateOrientation() {
        String orientation = null;
        if (this.resources != null) {
            switch (this.resources.getConfiguration().orientation) {
                case 2: {
                    orientation = "landscape";
                    break;
                }
                case 1: {
                    orientation = "portrait";
                    break;
                }
            }
        }
        return orientation;
    }

    @Nullable
    private Float getBatteryLevel() {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.appContext.registerReceiver(null, ifilter);
            return Float.valueOf((float)batteryStatus.getIntExtra("level", -1) / (float)batteryStatus.getIntExtra("scale", -1));
        }
        catch (Exception exception) {
            Logger.warn("Could not get batteryLevel");
            return null;
        }
    }

    @Nullable
    private Boolean isCharging() {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.appContext.registerReceiver(null, ifilter);
            int status = batteryStatus.getIntExtra("status", -1);
            return status == 2 || status == 5;
        }
        catch (Exception exception) {
            Logger.warn("Could not get charging status");
            return null;
        }
    }

    @Nullable
    private String getLocationStatus() {
        try {
            ContentResolver cr = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed != null && providersAllowed.length() > 0) {
                return "allowed";
            }
            return "disallowed";
        }
        catch (Exception exception) {
            Logger.warn("Could not get locationStatus");
            return null;
        }
    }

    @Nullable
    private String getNetworkAccess() {
        return this.connectivity.retrieveNetworkAccessState();
    }

    @NonNull
    private String getTime() {
        return DateUtils.toIso8601(new Date());
    }

    static class Abi2Wrapper {
        Abi2Wrapper() {
        }

        @NonNull
        static String[] getAbi1andAbi2() {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
    }

    static class SupportedAbiWrapper {
        SupportedAbiWrapper() {
        }

        @RequiresApi(value=21)
        static String[] getSupportedAbis() {
            return Build.SUPPORTED_ABIS;
        }
    }
}

