/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.AbstractBinaryTransaction;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.grid.jcache.Bucket4jJCache;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import javax.cache.spi.CachingProvider;

public class JCacheProxyManager<K>
extends AbstractProxyManager<K> {
    private static final Map<String, String> incompatibleProviders = Collections.emptyMap();
    private static final Set<String> preferLambdaStyleProviders = Collections.singleton("org.infinispan");
    private final Cache<K, byte[]> cache;
    private final boolean preferLambdaStyle;

    public JCacheProxyManager(Bucket4jJCache.JCacheProxyManagerBuilder<K> builder) {
        super(builder.getClientSideConfig());
        this.cache = builder.cache;
        this.checkCompatibilityWithProvider(this.cache);
        this.preferLambdaStyle = this.preferLambdaStyle(this.cache);
    }

    @Deprecated
    public JCacheProxyManager(Cache<K, byte[]> cache) {
        this(cache, ClientSideConfig.getDefault());
    }

    @Deprecated
    public JCacheProxyManager(Cache<K, byte[]> cache, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.checkCompatibilityWithProvider(cache);
        this.cache = Objects.requireNonNull(cache);
        this.preferLambdaStyle = this.preferLambdaStyle(cache);
    }

    public <T> CommandResult<T> execute(K key, Request<T> request) {
        EntryProcessor<K, byte[], byte[]> entryProcessor = this.preferLambdaStyle ? this.createLambdaProcessor(request) : new EntryProcessor<K, byte[], byte[]>(request);
        byte[] resultBytes = (byte[])this.cache.invoke(key, entryProcessor, new Object[0]);
        return InternalSerializationHelper.deserializeResult((byte[])resultBytes, (Version)request.getBackwardCompatibilityVersion());
    }

    public void removeProxy(K key) {
        this.cache.remove(key);
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        throw new UnsupportedOperationException();
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        throw new UnsupportedOperationException();
    }

    private void checkCompatibilityWithProvider(Cache<K, byte[]> cache) {
        CacheManager cacheManager = cache.getCacheManager();
        if (cacheManager == null) {
            return;
        }
        CachingProvider cachingProvider = cacheManager.getCachingProvider();
        if (cachingProvider == null) {
            return;
        }
        String providerClassName = cachingProvider.getClass().getName();
        incompatibleProviders.forEach((providerPrefix, recommendation) -> {
            if (providerClassName.startsWith((String)providerPrefix)) {
                String message = "The Cache provider " + providerClassName + " is incompatible with Bucket4j, " + recommendation;
                throw new UnsupportedOperationException(message);
            }
        });
    }

    private boolean preferLambdaStyle(Cache<K, byte[]> cache) {
        CacheManager cacheManager = cache.getCacheManager();
        if (cacheManager == null) {
            return false;
        }
        CachingProvider cachingProvider = cacheManager.getCachingProvider();
        if (cachingProvider == null) {
            return false;
        }
        String providerClassName = cachingProvider.getClass().getName();
        for (String providerPrefix : preferLambdaStyleProviders) {
            if (!providerClassName.startsWith(providerPrefix)) continue;
            return true;
        }
        return false;
    }

    public <T> EntryProcessor<K, byte[], byte[]> createLambdaProcessor(Request<T> request) {
        byte[] serializedRequest = InternalSerializationHelper.serializeRequest(request);
        return (EntryProcessor & Serializable)(mutableEntry, objects) -> new JCacheTransaction(mutableEntry, serializedRequest).execute();
    }

    private static class BucketProcessor<K, T>
    implements Serializable,
    EntryProcessor<K, byte[], byte[]> {
        private static final long serialVersionUID = 911L;
        private final byte[] serializedRequest;

        public BucketProcessor(Request<T> request) {
            this.serializedRequest = InternalSerializationHelper.serializeRequest(request);
        }

        public byte[] process(MutableEntry<K, byte[]> mutableEntry, Object ... arguments) {
            return new JCacheTransaction(mutableEntry, this.serializedRequest).execute();
        }
    }

    private static class JCacheTransaction
    extends AbstractBinaryTransaction {
        private final MutableEntry<?, byte[]> targetEntry;

        private JCacheTransaction(MutableEntry<?, byte[]> targetEntry, byte[] requestBytes) {
            super(requestBytes);
            this.targetEntry = targetEntry;
        }

        public boolean exists() {
            return this.targetEntry.exists();
        }

        protected byte[] getRawState() {
            return (byte[])this.targetEntry.getValue();
        }

        protected void setRawState(byte[] newStateBytes, RemoteBucketState newState) {
            this.targetEntry.setValue((Object)newStateBytes);
        }
    }
}

