/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.PrimitiveSerializationHandles;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConsumeAsMuchAsPossibleCommand
implements RemoteCommand<Long>,
ComparableByContent<ConsumeAsMuchAsPossibleCommand> {
    private long limit;
    public static final SerializationHandle<ConsumeAsMuchAsPossibleCommand> SERIALIZATION_HANDLE = new SerializationHandle<ConsumeAsMuchAsPossibleCommand>(){

        @Override
        public <S> ConsumeAsMuchAsPossibleCommand deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long limit = adapter.readLong(input);
            return new ConsumeAsMuchAsPossibleCommand(limit);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, ConsumeAsMuchAsPossibleCommand command, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeLong(output, command.limit);
        }

        @Override
        public int getTypeId() {
            return 25;
        }

        @Override
        public Class<ConsumeAsMuchAsPossibleCommand> getSerializedType() {
            return ConsumeAsMuchAsPossibleCommand.class;
        }

        @Override
        public ConsumeAsMuchAsPossibleCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long limit = this.readLongValue(snapshot, "limit");
            return new ConsumeAsMuchAsPossibleCommand(limit);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(ConsumeAsMuchAsPossibleCommand command, Version backwardCompatibilityVersion) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("limit", command.limit);
            return result;
        }

        @Override
        public String getTypeName() {
            return "ConsumeAsMuchAsPossibleCommand";
        }
    };

    public ConsumeAsMuchAsPossibleCommand(long limit) {
        this.limit = limit;
    }

    @Override
    public CommandResult<Long> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        state.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = state.getAvailableTokens();
        long toConsume = Math.min(this.limit, availableToConsume);
        if (toConsume <= 0L) {
            return CommandResult.ZERO;
        }
        state.consume(toConsume);
        mutableEntry.set(state);
        return CommandResult.success(Long.valueOf(toConsume), PrimitiveSerializationHandles.LONG_HANDLE);
    }

    public long getLimit() {
        return this.limit;
    }

    @Override
    public SerializationHandle getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(ConsumeAsMuchAsPossibleCommand other) {
        return this.limit == other.limit;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return this.limit == Long.MAX_VALUE;
    }

    @Override
    public long estimateTokensToConsume() {
        return this.limit;
    }

    @Override
    public long getConsumedTokens(Long result) {
        return result;
    }
}

