/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.remote.RemoteStat;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RemoteBucketState
implements ComparableByContent<RemoteBucketState> {
    private BucketState state;
    private RemoteStat stat;
    public static final SerializationHandle<RemoteBucketState> SERIALIZATION_HANDLE = new SerializationHandle<RemoteBucketState>(){

        @Override
        public <S> RemoteBucketState deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            BucketConfiguration bucketConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
            BucketState bucketState = BucketState.deserialize(adapter, input, backwardCompatibilityVersion);
            bucketState.setConfiguration(bucketConfiguration);
            RemoteStat stat = RemoteStat.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
            return new RemoteBucketState(bucketState, stat);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, RemoteBucketState gridState, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            BucketConfiguration.SERIALIZATION_HANDLE.serialize(adapter, output, gridState.getConfiguration(), backwardCompatibilityVersion);
            BucketState.serialize(adapter, output, gridState.state, backwardCompatibilityVersion);
            RemoteStat.SERIALIZATION_HANDLE.serialize(adapter, output, gridState.stat, backwardCompatibilityVersion);
        }

        @Override
        public int getTypeId() {
            return 5;
        }

        @Override
        public Class<RemoteBucketState> getSerializedType() {
            return RemoteBucketState.class;
        }

        @Override
        public RemoteBucketState fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            BucketState state = BucketState.fromJsonCompatibleSnapshot((Map)snapshot.get("state"), backwardCompatibilityVersion);
            RemoteStat stat = RemoteStat.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot((Map)snapshot.get("stat"), backwardCompatibilityVersion);
            return new RemoteBucketState(state, stat);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(RemoteBucketState remoteState, Version backwardCompatibilityVersion) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("state", BucketState.toJsonCompatibleSnapshot(remoteState.state, backwardCompatibilityVersion));
            result.put("stat", RemoteStat.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot(remoteState.stat, backwardCompatibilityVersion));
            return result;
        }

        @Override
        public String getTypeName() {
            return "RemoteBucketState";
        }
    };

    public RemoteBucketState(BucketState state, RemoteStat stat) {
        this.state = state;
        this.stat = stat;
    }

    public void refillAllBandwidth(long currentTimeNanos) {
        this.state.refillAllBandwidth(currentTimeNanos);
    }

    public long getAvailableTokens() {
        return this.state.getAvailableTokens();
    }

    public void consume(long tokensToConsume) {
        this.state.consume(tokensToConsume);
        this.stat.addConsumedTokens(tokensToConsume);
    }

    public long calculateFullRefillingTime(long currentTimeNanos) {
        return this.state.calculateFullRefillingTime(currentTimeNanos);
    }

    public long calculateDelayNanosAfterWillBePossibleToConsume(long tokensToConsume, long currentTimeNanos, boolean checkTokensToConsumeShouldBeLessThenCapacity) {
        return this.state.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, checkTokensToConsumeShouldBeLessThenCapacity);
    }

    public void addTokens(long tokensToAdd) {
        this.state.addTokens(tokensToAdd);
    }

    public void forceAddTokens(long tokensToAdd) {
        this.state.forceAddTokens(tokensToAdd);
    }

    public void reset() {
        this.state.reset();
    }

    public BucketState copyBucketState() {
        return this.state.copy();
    }

    public void replaceConfiguration(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy, long currentTimeNanos) {
        this.state = this.state.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
    }

    public BucketConfiguration getConfiguration() {
        return this.state.getConfiguration();
    }

    public RemoteStat getRemoteStat() {
        return this.stat;
    }

    public BucketState getState() {
        return this.state;
    }

    @Override
    public boolean equalsByContent(RemoteBucketState other) {
        return ComparableByContent.equals(this.state, other.state) && ComparableByContent.equals(this.state.getConfiguration(), other.getConfiguration()) && ComparableByContent.equals(this.stat, other.stat);
    }

    public RemoteBucketState copy() {
        return new RemoteBucketState(this.state.copy(), this.stat.copy());
    }

    public String toString() {
        return "RemoteBucketState{configuration=" + this.state.getConfiguration() + ", state=" + this.state + ", stat=" + this.stat + "}";
    }
}

