/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.BucketProxy;
import io.github.bucket4j.distributed.proxy.AsyncCommandExecutor;
import io.github.bucket4j.distributed.proxy.AsyncProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.CommandExecutor;
import io.github.bucket4j.distributed.proxy.DefaultAsyncBucketProxy;
import io.github.bucket4j.distributed.proxy.DefaultBucketProxy;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.github.bucket4j.distributed.proxy.RecoveryStrategy;
import io.github.bucket4j.distributed.proxy.RemoteAsyncBucketBuilder;
import io.github.bucket4j.distributed.proxy.RemoteBucketBuilder;
import io.github.bucket4j.distributed.proxy.optimization.Optimization;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.remote.commands.GetConfigurationCommand;
import io.github.bucket4j.distributed.versioning.Version;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public abstract class AbstractProxyManager<K>
implements ProxyManager<K> {
    private static final RecoveryStrategy DEFAULT_RECOVERY_STRATEGY = RecoveryStrategy.RECONSTRUCT;
    private static final Optimization DEFAULT_REQUEST_OPTIMIZER = Optimization.NONE_OPTIMIZED;
    private final ClientSideConfig clientSideConfig;
    private AsyncProxyManager<K> asyncView = new AsyncProxyManager<K>(){

        @Override
        public CompletableFuture<Optional<BucketConfiguration>> getProxyConfiguration(K key) {
            GetConfigurationCommand cmd = new GetConfigurationCommand();
            AbstractProxyManager.this.getClientSideTime();
            Request<BucketConfiguration> request = new Request<BucketConfiguration>(cmd, AbstractProxyManager.this.getBackwardCompatibilityVersion(), AbstractProxyManager.this.getClientSideTime());
            return AbstractProxyManager.this.executeAsync(key, request).thenApply(result -> {
                if (result.isBucketNotFound()) {
                    return Optional.empty();
                }
                return Optional.of((BucketConfiguration)result.getData());
            });
        }

        @Override
        public RemoteAsyncBucketBuilder<K> builder() {
            return new DefaultAsyncRemoteBucketBuilder();
        }

        @Override
        public CompletableFuture<Void> removeProxy(K key) {
            return AbstractProxyManager.this.removeAsync(key);
        }
    };

    protected AbstractProxyManager(ClientSideConfig clientSideConfig) {
        this.clientSideConfig = Objects.requireNonNull(clientSideConfig);
    }

    @Override
    public AsyncProxyManager<K> asAsync() {
        if (!this.isAsyncModeSupported()) {
            throw BucketExceptions.asyncModeIsNotSupported();
        }
        return this.asyncView;
    }

    @Override
    public RemoteBucketBuilder<K> builder() {
        return new DefaultRemoteBucketBuilder();
    }

    @Override
    public Optional<BucketConfiguration> getProxyConfiguration(K key) {
        GetConfigurationCommand cmd = new GetConfigurationCommand();
        Request<BucketConfiguration> request = new Request<BucketConfiguration>(cmd, this.getBackwardCompatibilityVersion(), this.getClientSideTime());
        CommandResult<BucketConfiguration> result = this.execute(key, request);
        if (result.isBucketNotFound()) {
            return Optional.empty();
        }
        return Optional.of(result.getData());
    }

    protected abstract <T> CommandResult<T> execute(K var1, Request<T> var2);

    protected abstract <T> CompletableFuture<CommandResult<T>> executeAsync(K var1, Request<T> var2);

    protected abstract CompletableFuture<Void> removeAsync(K var1);

    protected ClientSideConfig getClientSideConfig() {
        return this.clientSideConfig;
    }

    protected Version getBackwardCompatibilityVersion() {
        return this.clientSideConfig.getBackwardCompatibilityVersion();
    }

    protected Long getClientSideTime() {
        Optional<TimeMeter> clientClock = this.clientSideConfig.getClientSideClock();
        if (!clientClock.isPresent()) {
            return null;
        }
        return clientClock.get().currentTimeNanos();
    }

    private class DefaultRemoteBucketBuilder
    implements RemoteBucketBuilder<K> {
        private RecoveryStrategy recoveryStrategy = DEFAULT_RECOVERY_STRATEGY;
        private Optimization requestOptimizer = DEFAULT_REQUEST_OPTIMIZER;

        private DefaultRemoteBucketBuilder() {
        }

        @Override
        public RemoteBucketBuilder<K> withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
            this.recoveryStrategy = Objects.requireNonNull(recoveryStrategy);
            return this;
        }

        @Override
        public RemoteBucketBuilder<K> withOptimization(Optimization optimization) {
            this.requestOptimizer = Objects.requireNonNull(optimization);
            return this;
        }

        @Override
        public BucketProxy build(K key, BucketConfiguration configuration) {
            if (configuration == null) {
                throw BucketExceptions.nullConfiguration();
            }
            return this.build(key, () -> configuration);
        }

        @Override
        public BucketProxy build(final K key, Supplier<BucketConfiguration> configurationSupplier) {
            if (configurationSupplier == null) {
                throw BucketExceptions.nullConfigurationSupplier();
            }
            CommandExecutor commandExecutor = new CommandExecutor(){

                @Override
                public <T> CommandResult<T> execute(RemoteCommand<T> command) {
                    Request<T> request = new Request<T>(command, AbstractProxyManager.this.getBackwardCompatibilityVersion(), AbstractProxyManager.this.getClientSideTime());
                    return AbstractProxyManager.this.execute(key, request);
                }
            };
            commandExecutor = this.requestOptimizer.apply(commandExecutor);
            return new DefaultBucketProxy(configurationSupplier, commandExecutor, this.recoveryStrategy);
        }
    }

    private class DefaultAsyncRemoteBucketBuilder
    implements RemoteAsyncBucketBuilder<K> {
        private RecoveryStrategy recoveryStrategy = DEFAULT_RECOVERY_STRATEGY;
        private Optimization asyncRequestOptimizer = DEFAULT_REQUEST_OPTIMIZER;

        private DefaultAsyncRemoteBucketBuilder() {
        }

        public DefaultAsyncRemoteBucketBuilder withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
            this.recoveryStrategy = Objects.requireNonNull(recoveryStrategy);
            return this;
        }

        public DefaultAsyncRemoteBucketBuilder withOptimization(Optimization requestOptimizer) {
            this.asyncRequestOptimizer = Objects.requireNonNull(requestOptimizer);
            return this;
        }

        @Override
        public AsyncBucketProxy build(K key, BucketConfiguration configuration) {
            if (configuration == null) {
                throw BucketExceptions.nullConfiguration();
            }
            return this.build(key, () -> CompletableFuture.completedFuture(configuration));
        }

        @Override
        public AsyncBucketProxy build(final K key, Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier) {
            if (configurationSupplier == null) {
                throw BucketExceptions.nullConfigurationSupplier();
            }
            AsyncCommandExecutor commandExecutor = new AsyncCommandExecutor(){

                @Override
                public <T> CompletableFuture<CommandResult<T>> executeAsync(RemoteCommand<T> command) {
                    Request<T> request = new Request<T>(command, AbstractProxyManager.this.getBackwardCompatibilityVersion(), AbstractProxyManager.this.getClientSideTime());
                    return AbstractProxyManager.this.executeAsync(key, request);
                }
            };
            commandExecutor = this.asyncRequestOptimizer.apply(commandExecutor);
            return new DefaultAsyncBucketProxy(commandExecutor, this.recoveryStrategy, configurationSupplier);
        }
    }
}

