/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConsumptionProbe
implements ComparableByContent<ConsumptionProbe> {
    private final boolean consumed;
    private final long remainingTokens;
    private final long nanosToWaitForRefill;
    private final long nanosToWaitForReset;
    public static final SerializationHandle<ConsumptionProbe> SERIALIZATION_HANDLE = new SerializationHandle<ConsumptionProbe>(){

        @Override
        public <S> ConsumptionProbe deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            boolean consumed = adapter.readBoolean(input);
            long remainingTokens = adapter.readLong(input);
            long nanosToWaitForRefill = adapter.readLong(input);
            long nanosToWaitForReset = adapter.readLong(input);
            return new ConsumptionProbe(consumed, remainingTokens, nanosToWaitForRefill, nanosToWaitForReset);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, ConsumptionProbe probe, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeBoolean(output, probe.consumed);
            adapter.writeLong(output, probe.remainingTokens);
            adapter.writeLong(output, probe.nanosToWaitForRefill);
            adapter.writeLong(output, probe.nanosToWaitForReset);
        }

        @Override
        public int getTypeId() {
            return 11;
        }

        @Override
        public Class<ConsumptionProbe> getSerializedType() {
            return ConsumptionProbe.class;
        }

        @Override
        public ConsumptionProbe fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            boolean consumed = (Boolean)snapshot.get("consumed");
            long remainingTokens = this.readLongValue(snapshot, "remainingTokens");
            long nanosToWaitForRefill = this.readLongValue(snapshot, "nanosToWaitForRefill");
            long nanosToWaitForReset = this.readLongValue(snapshot, "nanosToWaitForReset");
            return new ConsumptionProbe(consumed, remainingTokens, nanosToWaitForRefill, nanosToWaitForReset);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(ConsumptionProbe probe, Version backwardCompatibilityVersion) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("consumed", probe.consumed);
            result.put("remainingTokens", probe.remainingTokens);
            result.put("nanosToWaitForRefill", probe.nanosToWaitForRefill);
            result.put("nanosToWaitForReset", probe.nanosToWaitForReset);
            return result;
        }

        @Override
        public String getTypeName() {
            return "ConsumptionProbe";
        }
    };

    public static ConsumptionProbe consumed(long remainingTokens, long nanosToWaitForReset) {
        return new ConsumptionProbe(true, remainingTokens, 0L, nanosToWaitForReset);
    }

    public static ConsumptionProbe rejected(long remainingTokens, long nanosToWaitForRefill, long nanosToWaitForReset) {
        return new ConsumptionProbe(false, remainingTokens, nanosToWaitForRefill, nanosToWaitForReset);
    }

    private ConsumptionProbe(boolean consumed, long remainingTokens, long nanosToWaitForRefill, long nanosToWaitForReset) {
        this.consumed = consumed;
        this.remainingTokens = Math.max(0L, remainingTokens);
        this.nanosToWaitForRefill = nanosToWaitForRefill;
        this.nanosToWaitForReset = nanosToWaitForReset;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public long getRemainingTokens() {
        return this.remainingTokens;
    }

    public long getNanosToWaitForRefill() {
        return this.nanosToWaitForRefill;
    }

    public long getNanosToWaitForReset() {
        return this.nanosToWaitForReset;
    }

    public String toString() {
        return "ConsumptionProbe{consumed=" + this.consumed + ", remainingTokens=" + this.remainingTokens + ", nanosToWaitForRefill=" + this.nanosToWaitForRefill + ", nanosToWaitForReset=" + this.nanosToWaitForReset + "}";
    }

    @Override
    public boolean equalsByContent(ConsumptionProbe other) {
        return this.consumed == other.consumed && this.remainingTokens == other.remainingTokens && this.nanosToWaitForRefill == other.nanosToWaitForRefill && this.nanosToWaitForReset == other.nanosToWaitForReset;
    }
}

