/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class BucketConfiguration
implements ComparableByContent<BucketConfiguration> {
    private final Bandwidth[] bandwidths;
    public static final SerializationHandle<BucketConfiguration> SERIALIZATION_HANDLE = new SerializationHandle<BucketConfiguration>(){

        @Override
        public <S> BucketConfiguration deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int bandwidthAmount = adapter.readInt(input);
            ArrayList<Bandwidth> bandwidths = new ArrayList<Bandwidth>(bandwidthAmount);
            for (int ii = 0; ii < bandwidthAmount; ++ii) {
                Bandwidth bandwidth = Bandwidth.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
                bandwidths.add(bandwidth);
            }
            return new BucketConfiguration(bandwidths);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, BucketConfiguration configuration, Version backwardCompatibilityVersion) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, configuration.bandwidths.length);
            for (Bandwidth bandwidth : configuration.bandwidths) {
                Bandwidth.SERIALIZATION_HANDLE.serialize(adapter, output, bandwidth, backwardCompatibilityVersion);
            }
        }

        @Override
        public int getTypeId() {
            return 2;
        }

        @Override
        public Class<BucketConfiguration> getSerializedType() {
            return BucketConfiguration.class;
        }

        @Override
        public BucketConfiguration fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            List bandwidthSnapshots = (List)snapshot.get("bandwidths");
            ArrayList<Bandwidth> bandwidths = new ArrayList<Bandwidth>(bandwidthSnapshots.size());
            for (Map bandwidthSnapshot : bandwidthSnapshots) {
                Bandwidth bandwidth = Bandwidth.SERIALIZATION_HANDLE.fromJsonCompatibleSnapshot(bandwidthSnapshot, backwardCompatibilityVersion);
                bandwidths.add(bandwidth);
            }
            return new BucketConfiguration(bandwidths);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(BucketConfiguration configuration, Version backwardCompatibilityVersion) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            ArrayList<Map<String, Object>> bandwidthList = new ArrayList<Map<String, Object>>(configuration.bandwidths.length);
            for (Bandwidth bandwidth : configuration.bandwidths) {
                bandwidthList.add(Bandwidth.SERIALIZATION_HANDLE.toJsonCompatibleSnapshot(bandwidth, backwardCompatibilityVersion));
            }
            result.put("bandwidths", bandwidthList);
            return result;
        }

        @Override
        public String getTypeName() {
            return "BucketConfiguration";
        }
    };

    public BucketConfiguration(List<Bandwidth> bandwidths) {
        int i;
        Objects.requireNonNull(bandwidths);
        if (bandwidths.isEmpty()) {
            throw BucketExceptions.restrictionsNotSpecified();
        }
        this.bandwidths = new Bandwidth[bandwidths.size()];
        for (i = 0; i < bandwidths.size(); ++i) {
            this.bandwidths[i] = Objects.requireNonNull(bandwidths.get(i));
        }
        for (i = 0; i < this.bandwidths.length; ++i) {
            if (this.bandwidths[i].getId() == Bandwidth.UNDEFINED_ID) continue;
            for (int j = i + 1; j < this.bandwidths.length; ++j) {
                if (!Objects.equals(this.bandwidths[i].getId(), this.bandwidths[j].getId())) continue;
                throw BucketExceptions.foundTwoBandwidthsWithSameId(i, j, this.bandwidths[i].getId());
            }
        }
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public Bandwidth[] getBandwidths() {
        return this.bandwidths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketConfiguration that = (BucketConfiguration)o;
        return Arrays.equals(this.bandwidths, that.bandwidths);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bandwidths);
    }

    public String toString() {
        return "BucketConfiguration{bandwidths=" + Arrays.toString(this.bandwidths) + "}";
    }

    @Override
    public boolean equalsByContent(BucketConfiguration other) {
        if (this.bandwidths.length != other.bandwidths.length) {
            return false;
        }
        for (int i = 0; i < other.getBandwidths().length; ++i) {
            Bandwidth bandwidth1 = this.bandwidths[i];
            Bandwidth bandwidth2 = other.bandwidths[i];
            if (bandwidth1.equalsByContent(bandwidth2)) continue;
            return false;
        }
        return true;
    }
}

