/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.selenium.junit4.runner;

import com.btmatthews.selenium.junit4.runner.SeleniumFactory;
import com.btmatthews.selenium.junit4.runner.WrappedDriverConfiguration;
import com.google.common.base.Supplier;
import com.thoughtworks.selenium.Selenium;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverBackedSelenium;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WrappedDriverFactory
implements SeleniumFactory<Selenium> {
    private final WrappedDriverConfiguration configuration;
    private final Class<? extends WebDriver> webDriverClass;

    public WrappedDriverFactory(WrappedDriverConfiguration config, Class<? extends WebDriver> driverClass) {
        this.configuration = config;
        this.webDriverClass = driverClass;
    }

    @Override
    public String getBrowser() {
        return this.webDriverClass.getSimpleName();
    }

    @Override
    public Selenium create() {
        return new WebDriverBackedSelenium((Supplier)new Supplier<WebDriver>(){

            public WebDriver get() {
                if (HtmlUnitDriver.class.isAssignableFrom(WrappedDriverFactory.this.webDriverClass)) {
                    DesiredCapabilities capabilities = DesiredCapabilities.htmlUnit();
                    capabilities.setJavascriptEnabled(true);
                    return new HtmlUnitDriver((Capabilities)capabilities);
                }
                try {
                    return (WebDriver)WrappedDriverFactory.this.webDriverClass.newInstance();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }, this.configuration.browserURL());
    }

    @Override
    public void start(Selenium server) {
        server.start();
    }

    @Override
    public void stop(Selenium server) {
        server.stop();
    }
}

