/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.selenium.junit4.rule;

import com.btmatthews.selenium.junit4.rule.DefaultScreenShotFilenameGenerator;
import com.btmatthews.selenium.junit4.rule.ScreenShotFilenameGenerator;
import com.btmatthews.selenium.junit4.runner.SeleniumServer;
import com.btmatthews.selenium.junit4.runner.SeleniumWebDriver;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenShotOnFailure
extends TestWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultScreenShotFilenameGenerator.class);
    @SeleniumServer
    private Selenium server;
    @SeleniumWebDriver
    private WebDriver webDriver;
    private final ScreenShotFilenameGenerator generator;

    public ScreenShotOnFailure(String screenshotDirectory) {
        this(new DefaultScreenShotFilenameGenerator(new File(screenshotDirectory)));
    }

    public ScreenShotOnFailure(ScreenShotFilenameGenerator generator) {
        this.generator = generator;
    }

    protected void failed(Throwable exception, Description description) {
        try {
            if (this.webDriver != null) {
                if (this.webDriver instanceof TakesScreenshot) {
                    File target = this.generator.getTargetFilename(description);
                    byte[] source = (byte[])((TakesScreenshot)this.webDriver).getScreenshotAs(OutputType.BYTES);
                    FileUtils.forceMkdir((File)target.getParentFile());
                    FileUtils.writeByteArrayToFile((File)target, (byte[])source);
                }
            } else {
                File target = this.generator.getTargetFilename(description);
                FileUtils.forceMkdir((File)target.getParentFile());
                this.server.captureEntirePageScreenshot(target.getAbsolutePath(), "");
            }
        }
        catch (IOException e) {
            LOGGER.error("I/O error capturing screen shot after failure", (Throwable)e);
        }
    }
}

