/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graphview.SmartGraphPanel;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertex;
import com.brunomnsilva.smartgraph.graphview.SmartPlacementStrategy;
import com.brunomnsilva.smartgraph.graphview.UtilitiesPoint2D;
import java.util.ArrayList;
import javafx.geometry.Point2D;

public class SmartCircularSortedPlacementStrategy
implements SmartPlacementStrategy {
    private static final int RADIUS_PADDING = 4;

    @Override
    public <V, E> void place(double width, double height, SmartGraphPanel<V, E> smartGraphPanel) {
        ArrayList<SmartGraphVertex<V>> vertices = new ArrayList<SmartGraphVertex<V>>(smartGraphPanel.getSmartVertices());
        vertices.sort((v1, v2) -> {
            Object e1 = v1.getUnderlyingVertex().element();
            Object e2 = v2.getUnderlyingVertex().element();
            return smartGraphPanel.getVertexLabelFor(e1).compareTo(smartGraphPanel.getVertexLabelFor(e2));
        });
        Point2D center = new Point2D(width / 2.0, height / 2.0);
        int N = vertices.size();
        double angleIncrement = -360.0f / (float)N;
        boolean first = true;
        Point2D p = null;
        for (SmartGraphVertex smartGraphVertex : vertices) {
            if (first) {
                p = width > height ? new Point2D(center.getX(), center.getY() - height / 2.0 + smartGraphVertex.getRadius() * 4.0) : new Point2D(center.getX(), center.getY() - width / 2.0 + smartGraphVertex.getRadius() * 4.0);
                first = false;
            } else {
                p = UtilitiesPoint2D.rotate(p, center, angleIncrement);
            }
            smartGraphVertex.setPosition(p.getX(), p.getY());
        }
    }
}

