/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

public final class Args {
    public static void requireNotNull(Object param, String name) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Require '%s' to be not null.", name));
        }
    }

    public static void requireGreaterThan(double value, String name, double minValue) {
        if (value <= minValue) {
            throw new IllegalArgumentException(String.format("Require '%s' (%f) to be greater than %f.", name, value, minValue));
        }
    }

    public static void requireNonNegative(double value, String name) {
        if (value < 0.0) {
            throw new IllegalArgumentException(String.format("Require '%s' (%f) to be non-negative.", name, value));
        }
    }

    public static void requireInRange(double value, String name, double lowerBound, double upperBound) {
        if (value < lowerBound || value > upperBound) {
            throw new IllegalArgumentException(String.format("Require '%s' (%f) to be in range [%f, %f].", name, value, lowerBound, upperBound));
        }
    }

    public static void requireFinite(double value, String name) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException(String.format("Require '%s' (%f) to be finite.", name, value));
        }
    }
}

